/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.xz;

import java.io.InputStream;
import me.lucko.spark.lib.xz.ArrayCache;
import me.lucko.spark.lib.xz.DeltaEncoder;
import me.lucko.spark.lib.xz.DeltaInputStream;
import me.lucko.spark.lib.xz.DeltaOutputStream;
import me.lucko.spark.lib.xz.FilterEncoder;
import me.lucko.spark.lib.xz.FilterOptions;
import me.lucko.spark.lib.xz.FinishableOutputStream;
import me.lucko.spark.lib.xz.UnsupportedOptionsException;

public class DeltaOptions
extends FilterOptions {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private int distance = 1;

    public DeltaOptions() {
    }

    public DeltaOptions(int n) throws UnsupportedOptionsException {
        this.setDistance(n);
    }

    public void setDistance(int n) throws UnsupportedOptionsException {
        if (n < 1 || n > 256) {
            throw new UnsupportedOptionsException("Delta distance must be in the range [1, 256]: " + n);
        }
        this.distance = n;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getEncoderMemoryUsage() {
        return DeltaOutputStream.getMemoryUsage();
    }

    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        return new DeltaOutputStream(finishableOutputStream, this);
    }

    public int getDecoderMemoryUsage() {
        return 1;
    }

    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new DeltaInputStream(inputStream, this.distance);
    }

    FilterEncoder getFilterEncoder() {
        return new DeltaEncoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

