/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.recipes.JsonHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PotionProviderRecipe
implements IRecipe<RecipeWrapper> {
    public static final IRecipeType<PotionProviderRecipe> TYPE = IRecipeType.func_222147_a((String)"jeed:potion_provider");
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final NonNullList<ItemStack> providers;
    private final List<Potion> potions;

    public PotionProviderRecipe(ResourceLocation id, NonNullList<ItemStack> providers, List<Potion> potions) {
        this.id = id;
        this.providers = providers;
        this.potions = potions;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return "potion_provider";
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonNullList = NonNullList.func_191196_a();
        nonNullList.add((Object)Ingredient.field_193370_a);
        return nonNullList;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean matches(RecipeWrapper inv, World worldIn) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper wrapper) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public NonNullList<ItemStack> getProviders() {
        return this.providers;
    }

    public List<Potion> getPotions() {
        return this.potions;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PotionProviderRecipe> {
        public Serializer() {
            this.setRegistryName(Jeed.res("potion_provider"));
        }

        public PotionProviderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            List<Potion> potions;
            NonNullList<ItemStack> providers = JsonHelper.readItemStackList(JSONUtils.func_151214_t((JsonObject)json, (String)"providers"));
            try {
                potions = JsonHelper.readPotionList(JSONUtils.func_151214_t((JsonObject)json, (String)"potions"));
            }
            catch (Exception ignored) {
                potions = new ArrayList<Potion>();
            }
            if (providers.isEmpty()) {
                throw new JsonParseException("No effect providers for recipe");
            }
            return new PotionProviderRecipe(recipeId, providers, potions);
        }

        @Nullable
        public PotionProviderRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            NonNullList providers = NonNullList.func_191197_a((int)i, (Object)ItemStack.field_190927_a);
            for (int j = 0; j < providers.size(); ++j) {
                providers.set(j, (Object)buffer.func_150791_c());
            }
            int x = buffer.func_150792_a();
            ArrayList<Potion> potions = new ArrayList<Potion>();
            for (int y = 0; y < x; ++y) {
                potions.add(JsonHelper.getPotion(buffer.func_192575_l()));
            }
            return new PotionProviderRecipe(recipeId, (NonNullList<ItemStack>)providers, potions);
        }

        public void toNetwork(PacketBuffer buffer, PotionProviderRecipe recipe) {
            buffer.func_150787_b(recipe.providers.size());
            for (ItemStack result : recipe.providers) {
                buffer.func_150788_a(result);
            }
            buffer.func_150787_b(recipe.potions.size());
            for (Potion potion : recipe.potions) {
                buffer.func_192572_a(potion.getRegistryName());
            }
        }
    }
}

