/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.recipes.JsonHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EffectProviderRecipe
implements IRecipe<RecipeWrapper> {
    public static final IRecipeType<EffectProviderRecipe> TYPE = IRecipeType.func_222147_a((String)"jeed:effect_provider");
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final Effect effect;
    private final boolean allEffects;
    private final NonNullList<ItemStack> providers;

    public EffectProviderRecipe(ResourceLocation id, Effect effect, NonNullList<ItemStack> providers) {
        this.id = id;
        this.effect = effect;
        this.providers = providers;
        this.allEffects = false;
    }

    public EffectProviderRecipe(ResourceLocation id, NonNullList<ItemStack> providers) {
        this.id = id;
        this.effect = null;
        this.providers = providers;
        this.allEffects = true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return "effect_provider";
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonNullList = NonNullList.func_191196_a();
        nonNullList.add((Object)Ingredient.field_193370_a);
        return nonNullList;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean matches(RecipeWrapper inv, World worldIn) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper wrapper) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public Collection<Effect> getEffects() {
        return this.allEffects ? ForgeRegistries.POTIONS.getValues() : Collections.singletonList(this.effect);
    }

    public NonNullList<ItemStack> getProviders() {
        return this.providers;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EffectProviderRecipe> {
        public Serializer() {
            this.setRegistryName(Jeed.res("effect_provider"));
        }

        public EffectProviderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<ItemStack> providers = JsonHelper.readItemStackList(JSONUtils.func_151214_t((JsonObject)json, (String)"providers"));
            if (providers.isEmpty()) {
                throw new JsonParseException("No effect providers for recipe");
            }
            String effectID = JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject("effect"), (String)"id");
            if (effectID.equals("all") || effectID.equals("minecraft:all")) {
                return new EffectProviderRecipe(recipeId, providers);
            }
            Effect effect = JsonHelper.getEffect(new ResourceLocation(effectID));
            return new EffectProviderRecipe(recipeId, effect, providers);
        }

        @Nullable
        public EffectProviderRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            NonNullList providers = NonNullList.func_191197_a((int)i, (Object)ItemStack.field_190927_a);
            for (int j = 0; j < providers.size(); ++j) {
                providers.set(j, (Object)buffer.func_150791_c());
            }
            ResourceLocation id = buffer.func_192575_l();
            if (id.func_110623_a().equals("all")) {
                return new EffectProviderRecipe(recipeId, (NonNullList<ItemStack>)providers);
            }
            Effect effect = JsonHelper.getEffect(id);
            return new EffectProviderRecipe(recipeId, effect, (NonNullList<ItemStack>)providers);
        }

        public void toNetwork(PacketBuffer buffer, EffectProviderRecipe recipe) {
            buffer.func_150787_b(recipe.providers.size());
            for (ItemStack result : recipe.providers) {
                buffer.func_150788_a(result);
            }
            ResourceLocation res = recipe.allEffects ? new ResourceLocation("all") : recipe.effect.getRegistryName();
            buffer.func_192572_a(res);
        }
    }
}

