/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.mehvahdjukaar.jeed.jei.plugins.CompatHandler;
import net.mehvahdjukaar.jeed.jei.plugins.FantasyMountsPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EffectInstanceRenderer
implements IIngredientRenderer<EffectInstance> {
    public static final EffectInstanceRenderer INSTANCE = new EffectInstanceRenderer(true);
    public static final EffectInstanceRenderer INSTANCE_SLOT = new EffectInstanceRenderer(false);
    private final Minecraft MC = Minecraft.func_71410_x();
    private final boolean offset;

    public EffectInstanceRenderer(boolean offset) {
        this.offset = offset;
    }

    public void render(MatrixStack matrixStack, int xPosition, int yPosition, @Nullable EffectInstance effectInstance) {
        if (effectInstance != null) {
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            PotionSpriteUploader potionspriteuploader = this.MC.func_213248_ap();
            Effect effect = effectInstance.func_188419_a();
            int o = this.offset ? -1 : (CompatHandler.REI ? 3 : 0);
            xPosition += o;
            yPosition += o;
            boolean compatStuffSuccess = false;
            if (CompatHandler.FM) {
                compatStuffSuccess = FantasyMountsPlugin.renderOptionalEffect(effect, matrixStack, xPosition, yPosition);
            }
            if (!compatStuffSuccess) {
                TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(effect);
                this.MC.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
                AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)xPosition, (int)yPosition, (int)0, (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
        }
    }

    public List<ITextComponent> getTooltip(EffectInstance effectInstance, ITooltipFlag tooltipFlag) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        Effect effect = effectInstance.func_188419_a();
        if (effect != null) {
            String name = I18n.func_135052_a((String)effectInstance.func_188419_a().func_76393_a(), (Object[])new Object[0]);
            int amp = effectInstance.func_76458_c();
            if (amp >= 1 && amp <= 9) {
                name = name + ' ' + I18n.func_135052_a((String)("enchantment.level." + (amp + 1)), (Object[])new Object[0]);
            }
            tooltip.add((ITextComponent)new StringTextComponent(name));
            StringTextComponent colorValue = new StringTextComponent("#" + Integer.toHexString(effect.func_76401_j()));
            colorValue.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)effect.func_76401_j())));
            IFormattableTextComponent color = new TranslationTextComponent("jeed.tooltip.color").func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)new TranslationTextComponent("jeed.tooltip.color_complete", new Object[]{color, colorValue}));
            if (effect.func_188408_i()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("jeed.tooltip.beneficial").func_240699_a_(TextFormatting.BLUE));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("jeed.tooltip.harmful").func_240699_a_(TextFormatting.RED));
            }
            ArrayList list1 = Lists.newArrayList();
            Map map = effect.func_111186_k();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectInstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                    list1.add(new Pair(entry.getKey(), (Object)attributemodifier1));
                }
            }
            if (!list1.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
                tooltip.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
                for (Pair pair : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                    double d0 = attributemodifier2.func_111164_d();
                    double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
                }
            }
            if (tooltipFlag.func_194127_a()) {
                tooltip.add((ITextComponent)new StringTextComponent(effect.getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }
}

