/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei.ingredient;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class EffectInstanceHelper
implements IIngredientHelper<EffectInstance> {
    @Nullable
    public EffectInstance getMatch(Iterable<EffectInstance> ingredients, EffectInstance toMatch) {
        for (EffectInstance effect : ingredients) {
            if (!toMatch.equals((Object)effect)) continue;
            return effect;
        }
        return null;
    }

    public String getDisplayName(EffectInstance ingredient) {
        ITextComponent displayName = ingredient.func_188419_a().func_199286_c();
        return displayName.getString();
    }

    public String getUniqueId(EffectInstance ingredient) {
        ResourceLocation registryName = ingredient.func_188419_a().getRegistryName();
        return "effect:" + registryName;
    }

    public String getModId(EffectInstance ingredient) {
        ResourceLocation registryName = ingredient.func_188419_a().getRegistryName();
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("effect.getRegistryName() returned null for: " + ingredientInfo);
        }
        return registryName.func_110624_b();
    }

    public String getResourceId(EffectInstance ingredient) {
        ResourceLocation registryName = ingredient.func_188419_a().getRegistryName();
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("ingredient.getRegistryName() returned null for: " + ingredientInfo);
        }
        return registryName.func_110623_a();
    }

    public Iterable<Integer> getColors(EffectInstance ingredient) {
        return Collections.singletonList(ingredient.func_188419_a().func_76401_j());
    }

    public ItemStack getCheatItemStack(EffectInstance ingredient) {
        return PotionUtils.func_185184_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), Collections.singletonList(this.normalizeIngredient(ingredient)));
    }

    public EffectInstance copyIngredient(EffectInstance ingredient) {
        return new EffectInstance(ingredient.func_188419_a(), ingredient.func_76459_b(), ingredient.func_76458_c(), ingredient.func_82720_e(), ingredient.func_188418_e(), ingredient.func_205348_f());
    }

    public EffectInstance normalizeIngredient(EffectInstance ingredient) {
        return new EffectInstance(ingredient.func_188419_a(), 600);
    }

    public Collection<ResourceLocation> getTags(EffectInstance ingredient) {
        return Collections.singletonList(new ResourceLocation("jeed", "effects"));
    }

    public String getErrorInfo(@Nullable EffectInstance ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(FluidStack.class);
        Effect effect = ingredient.func_188419_a();
        if (effect != null) {
            ITextComponent displayName = ingredient.func_188419_a().func_199286_c();
            toStringHelper.add("Effect", (Object)displayName.getString());
        } else {
            toStringHelper.add("Effect", (Object)"null");
        }
        toStringHelper.add("Duration", ingredient.func_76459_b());
        toStringHelper.add("Amplifier", ingredient.func_76458_c());
        return toStringHelper.toString();
    }
}

