/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.jei.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.jei.EffectRecipeCategory;
import net.mehvahdjukaar.jeed.jei.ingredient.EffectInstanceHelper;
import net.mehvahdjukaar.jeed.jei.ingredient.EffectInstanceRenderer;
import net.mehvahdjukaar.jeed.jei.plugins.CompatHandler;
import net.mehvahdjukaar.jeed.jei.plugins.VanillaPlugin;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Jeed.res("jei_plugin");
    public static final IIngredientType<EffectInstance> EFFECT = () -> EffectInstance.class;
    public static IJeiRuntime JEI_RUNTIME;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new EffectRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(EFFECT, JEIPlugin.getEffectList(), (IIngredientHelper)new EffectInstanceHelper(), (IIngredientRenderer)EffectInstanceRenderer.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registry) {
        for (EffectInstance e : JEIPlugin.getEffectList()) {
            ResourceLocation name = e.func_188419_a().getRegistryName();
            this.registerEffectInfo(registry, new EffectInstance(e), EFFECT, "effect." + name.func_110624_b() + "." + name.func_110623_a() + ".description");
        }
    }

    private static List<EffectInstance> getEffectList() {
        return ForgeRegistries.POTIONS.getValues().stream().filter(e -> !((List)Jeed.HIDDEN_EFFECTS.get()).contains(e.getRegistryName().toString())).map(EffectInstance::new).filter(IForgeEffectInstance::shouldRender).collect(Collectors.toList());
    }

    public void registerEffectInfo(IRecipeRegistration registration, EffectInstance ingredient, IIngredientType<EffectInstance> ingredientType, String descriptionKey) {
        List<EffectInfoRecipe> recipes = EffectInfoRecipe.create(ingredient, ingredientType, descriptionKey);
        registration.addRecipes(recipes, EffectRecipeCategory.UID);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!CompatHandler.REI) {
            VanillaPlugin.registerGuiHandlers(registration);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        VanillaPlugin.registerRecipeCatalysts(registration);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEI_RUNTIME = jeiRuntime;
    }
}

