/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.jei.EffectBox;
import net.mehvahdjukaar.jeed.jei.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.jei.JEIPlugin;
import net.mehvahdjukaar.jeed.jei.TabIcon;
import net.mehvahdjukaar.jeed.jei.ingredient.EffectInstanceRenderer;
import net.mehvahdjukaar.jeed.utils.HSLColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EffectRecipeCategory
implements IRecipeCategory<EffectInfoRecipe> {
    public static final ResourceLocation UID = Jeed.res("effects");
    private static final TabIcon ICON = new TabIcon();
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private static final int lineSpacing = 2;
    private static final int yOffset = 12;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final IDrawable effectBackground;
    private final ITextComponent localizedName;

    public EffectRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.effectBackground = new EffectBox();
        this.icon = ICON;
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = new TranslationTextComponent("jeed.category.effect_info");
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends EffectInfoRecipe> getRecipeClass() {
        return EffectInfoRecipe.class;
    }

    @Deprecated
    public String getTitle() {
        return this.localizedName.getString();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(EffectInfoRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputItems());
        ingredients.setOutput(recipe.getEffectIngredientType(), (Object)recipe.getEffect());
    }

    public void draw(EffectInfoRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        boolean xPos = false;
        int yPos = this.effectBackground.getHeight() + 4 + 12;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        Effect effect = recipe.getEffect().func_188419_a();
        TextComponent name = (TextComponent)effect.func_199286_c();
        int color = HSLColor.getProcessedColor(effect.func_76401_j());
        name.func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240718_a_(Color.func_240743_a_((int)color)));
        float x = 80.0f - (float)font.func_238414_a_((ITextProperties)name) / 2.0f;
        font.func_238407_a_(matrixStack, LanguageMap.func_74808_a().func_241870_a((ITextProperties)name), x, 0.0f, -16777216);
        for (ITextProperties descriptionLine : recipe.getDescription()) {
            font.func_238422_b_(matrixStack, LanguageMap.func_74808_a().func_241870_a(descriptionLine), (float)xPos, (float)yPos, -16777216);
            font.getClass();
            yPos += 9 + 2;
        }
        for (int slotId = 0; slotId < 14; ++slotId) {
            this.slotBackground.draw(matrixStack, (int)(80.0f + 19.0f * ((float)(slotId % 7) - 3.5f)), 125 - 19 * (1 + slotId / 7));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, EffectInfoRecipe recipe, IIngredients ingredients) {
        int slotId;
        IGuiIngredientGroup guiEffectInstances = recipeLayout.getIngredientsGroup(JEIPlugin.EFFECT);
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        boolean box = (Boolean)Jeed.EFFECT_BOX.get();
        int offset = box ? 3 : 0;
        int xPos = 71;
        guiEffectInstances.init(0, true, (IIngredientRenderer)EffectInstanceRenderer.INSTANCE_SLOT, xPos - offset, 15 - offset, 18 + offset * 2, 18 + offset * 2, offset, offset);
        if (box) {
            guiEffectInstances.setBackground(0, this.effectBackground);
        }
        guiEffectInstances.set(0, (Object)recipe.getEffect());
        List<List> slotContents = Arrays.asList(NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a());
        List<ItemStack> compatible = recipe.getInputItems();
        for (slotId = 0; slotId < compatible.size(); ++slotId) {
            slotContents.get(slotId % slotContents.size()).add(compatible.get(slotId));
        }
        for (slotId = 0; slotId < slotContents.size(); ++slotId) {
            stacks.init(slotId + 1, false, (int)(80.0f + 19.0f * ((float)(slotId % 7) - 3.5f)), 125 - 19 * (2 - slotId / 7));
            stacks.set(slotId + 1, slotContents.get(slotId));
        }
    }
}

