/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.crop.ICropGetter;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.Set;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.InterModComms;

public class TOPCompat
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "mysticalagriculture:crops";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockState state, IProbeHitData data) {
                Block block = state.func_177230_c();
                BlockPos pos = data.getPos();
                if (block instanceof ICropGetter) {
                    Biome biome;
                    Set<ResourceLocation> biomes;
                    Block crux;
                    ICrop crop = ((ICropGetter)block).getCrop();
                    Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
                    info.text((ITextComponent)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
                    double secondaryChance = crop.getSecondaryChance(belowBlock);
                    if (secondaryChance > 0.0) {
                        IFormattableTextComponent chanceText = new StringTextComponent(String.valueOf((int)(secondaryChance * 100.0))).func_240702_b_("%").func_240699_a_(crop.getTier().getTextColor());
                        info.text((ITextComponent)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
                    }
                    if ((crux = crop.getCrux()) != null) {
                        ItemStack stack = new ItemStack((IItemProvider)crux);
                        info.text((ITextComponent)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack.func_200301_q()}).build());
                    }
                    if (!(biomes = crop.getRequiredBiomes()).isEmpty() && !biomes.contains((biome = world.func_226691_t_(pos)).getRegistryName())) {
                        info.text((ITextComponent)ModTooltips.INVALID_BIOME.color(TextFormatting.RED).build());
                    }
                    if (block instanceof InferiumCropBlock) {
                        int output = 100;
                        if (belowBlock instanceof IEssenceFarmland) {
                            IEssenceFarmland farmland = (IEssenceFarmland)belowBlock;
                            int tier = farmland.getTier().getValue();
                            output = tier * 50 + 50;
                        }
                        IFormattableTextComponent inferiumOutputText = new StringTextComponent(String.valueOf(output)).func_240702_b_("%").func_240699_a_(crop.getTier().getTextColor());
                        info.text((ITextComponent)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
                    }
                }
                if (block instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)block;
                    info.text((ITextComponent)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
                }
            }
        });
        return null;
    }

    public static void onInterModEnqueue() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPCompat::new);
    }
}

