/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class HealthBoostAugment
extends Augment {
    private static final UUID ATTRIBUTE_ID = UUID.fromString("e04addf9-0fe8-4498-b5a8-45e5201cd76d");
    private final int amplifier;

    public HealthBoostAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.ARMOR), HealthBoostAugment.getColor(12984891, tier), HealthBoostAugment.getColor(3867650, tier));
        this.amplifier = amplifier;
    }

    @Override
    public void onPlayerTick(World world, PlayerEntity player, AbilityCache cache) {
        if (!cache.isCached(this, player)) {
            ModifiableAttributeInstance health = player.func_110148_a(Attributes.field_233818_a_);
            if (health == null) {
                return;
            }
            int boost = 4 * this.amplifier;
            AttributeModifier modifier = health.func_111127_a(ATTRIBUTE_ID);
            if (modifier != null) {
                if ((double)boost < modifier.func_111164_d()) {
                    return;
                }
                health.func_111124_b(modifier);
                cache.getCachedAbilities(player).forEach(c -> {
                    IAugment augment = AugmentRegistry.getInstance().getAugmentById(new ResourceLocation(c));
                    if (augment instanceof HealthBoostAugment && cache.isCached(augment, player)) {
                        cache.removeQuietly((String)c, player);
                    }
                });
            }
            health.func_233769_c_(new AttributeModifier(ATTRIBUTE_ID, "mysticalagriculture:health_boost_augment", (double)boost, AttributeModifier.Operation.ADDITION));
            cache.add(this, player, () -> {
                float max = player.func_110138_aP() - (float)boost;
                if (player.func_110143_aJ() > max) {
                    player.func_70606_j(max);
                }
                health.func_188479_b(ATTRIBUTE_ID);
            });
        }
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

