/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CentrifugeTiers.gui.screen;

import com.YTrollman.CentrifugeTiers.container.CentrifugeMultiblockContainerTier5;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.resourcefulbees.resourcefulbees.client.gui.widget.TabToggleImageButton;
import com.resourcefulbees.resourcefulbees.lib.ModConstants;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.DrainCentrifugeTankMessage;
import com.resourcefulbees.resourcefulbees.network.packets.UpdateRedstoneReqMessage;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;

public class CentrifugeMultiblockScreenTier5
extends ContainerScreen<CentrifugeMultiblockContainerTier5> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("resourcefulbees", "textures/gui/centrifuges/centrifuge_gui.png");
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("textures/gui/recipe_button.png");
    protected static final int L_BDR_WD = 7;
    protected static final int BG_FILL_WD = 5;
    protected static final int R_BDR_WD = 7;
    protected static final int TOP_PAD = 7;
    protected static final int SLOT_WD = 18;
    protected static final int SLOT_HT = 18;
    protected static final int DBL_SLOT_WD = 36;
    protected static final int DBL_SLOT_HT = 36;
    protected static final int INV_START_Y = 103;
    protected static final int TAB_BG_WIDTH = 25;
    protected int bgRpt;
    protected int numInputs;
    protected int inputStartX;
    protected int outputStartX;
    protected int rBdrCor;
    protected int screenWidth;
    private TabToggleImageButton redstoneButton;
    private TabToggleImageButton fluidDispButton;

    public CentrifugeMultiblockScreenTier5(CentrifugeMultiblockContainerTier5 screenContainer, PlayerInventory inventory, ITextComponent titleIn) {
        super((Container)screenContainer, inventory, titleIn);
        this.numInputs = screenContainer.getCentrifugeTileEntity().getNumberOfInputs();
        this.initializeData();
        this.screenWidth = Math.max(this.numInputs * 36 + 70, 178);
        this.field_146999_f = this.screenWidth + 25;
        this.field_147000_g = 186;
        this.bgRpt = MathUtils.clamp((int)((this.field_146999_f - 7 - 7 - 25) / 5), (int)41, (int)68);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int buttonX = this.field_147003_i + this.field_146999_f - 25 - 6;
        int top = this.field_147009_r + 6;
        this.redstoneButton = (TabToggleImageButton)this.func_230480_a_((Widget)new TabToggleImageButton(buttonX, top + 4, 18, 18, 25, 220, 18, 18, ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getRequiresRedstone(), BACKGROUND, new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_151137_ax), onPress -> this.setRedstoneControl()){

            public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
                TranslationTextComponent s = new TranslationTextComponent("gui.resourcefulbees.centrifuge.button.redstone." + this.stateTriggered);
                CentrifugeMultiblockScreenTier5.this.func_238652_a_(matrix, (ITextComponent)s, mouseX, mouseY);
            }
        });
        this.fluidDispButton = (TabToggleImageButton)this.func_230480_a_((Widget)new TabToggleImageButton(buttonX, top + 24, 18, 18, 25, 220, 0, 18, ((CentrifugeMultiblockContainerTier5)this.field_147002_h).shouldDisplayFluids(), BACKGROUND, new ItemStack((IItemProvider)Items.field_151131_as), new ItemStack((IItemProvider)Items.field_226635_pU_), onPress -> this.displayFluids()){

            public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
                TranslationTextComponent s = new TranslationTextComponent("gui.resourcefulbees.centrifuge.button.fluid_display." + this.stateTriggered);
                CentrifugeMultiblockScreenTier5.this.func_238652_a_(matrix, (ITextComponent)s, mouseX, mouseY);
            }
        });
        this.func_230480_a_((Widget)new ImageButton(buttonX - 1, top + 44, 20, 18, 0, 0, 19, RECIPE_BUTTON_TEXTURE, button -> {}));
    }

    private void displayFluids() {
        this.fluidDispButton.setStateTriggered(!this.fluidDispButton.isStateTriggered());
        ((CentrifugeMultiblockContainerTier5)this.field_147002_h).setDisplayFluids(this.fluidDispButton.isStateTriggered());
        ((CentrifugeMultiblockContainerTier5)this.field_147002_h).setupSlots();
    }

    private void setRedstoneControl() {
        this.redstoneButton.setStateTriggered(!this.redstoneButton.isStateTriggered());
        NetPacketHandler.sendToServer((Object)new UpdateRedstoneReqMessage(((CentrifugeMultiblockContainerTier5)this.field_147002_h).getCentrifugeTileEntity().func_174877_v()));
    }

    protected void initializeData() {
        this.inputStartX = 19;
        this.outputStartX = 10;
        this.rBdrCor = -2;
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        Minecraft client = this.field_230706_i_;
        if (client != null) {
            client.func_110434_K().func_110577_a(BACKGROUND);
            int left = this.field_147003_i;
            int top = this.field_147009_r;
            this.drawBackground(matrix, left, top);
            this.drawInputSlots(matrix, left, top);
            if (((CentrifugeMultiblockContainerTier5)this.field_147002_h).shouldDisplayFluids()) {
                this.drawFluidTanks(matrix, left, top);
            } else {
                this.drawOutputSlots(matrix, left, top);
            }
            this.drawPowerBar(matrix, left, top);
            this.drawInventorySlots(matrix, left, top);
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        this.redstoneButton.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.fluidDispButton.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
        int x = this.field_147003_i + 10;
        int y = this.field_147009_r + 38;
        if (MathUtils.inRangeInclusive((int)mouseX, (int)x, (int)(x + 12)) && MathUtils.inRangeInclusive((int)mouseY, (int)y, (int)(y + 58))) {
            if (Screen.func_231173_s_() || ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getEnergy() < 500) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(((CentrifugeMultiblockContainerTier5)this.field_147002_h).getEnergy() + " RF"), mouseX, mouseY);
            } else {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(ModConstants.DECIMAL_FORMAT.format(((CentrifugeMultiblockContainerTier5)this.field_147002_h).getEnergy() / 1000) + " kRF"), mouseX, mouseY);
            }
        }
        if (((CentrifugeMultiblockContainerTier5)this.field_147002_h).shouldDisplayFluids()) {
            x = this.field_147003_i + 7 + 18;
            y = this.field_147009_r + 7 + 36;
            if (MathUtils.inRangeInclusive((int)mouseX, (int)(x - 17), (int)(x - 17 + 18)) && MathUtils.inRangeInclusive((int)mouseY, (int)(y + 65), (int)(y + 65 + 54))) {
                this.renderFluidToolTip(matrix, mouseX, mouseY, ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getFluidInTank(0));
            } else {
                for (int i = 0; i < this.numInputs; ++i) {
                    x = this.field_147003_i + this.outputStartX + 18 + 9 + i * 36;
                    if (!MathUtils.inRangeInclusive((int)mouseX, (int)x, (int)(x + 18)) || !MathUtils.inRangeInclusive((int)mouseY, (int)y, (int)(y + 54))) continue;
                    this.renderFluidToolTip(matrix, mouseX, mouseY, ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getFluidInTank(i + 1));
                }
            }
        }
    }

    public void func_230451_b_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrix, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    private void drawBackground(MatrixStack matrix, int left, int top) {
        this.func_238474_b_(matrix, left, top, 0, 0, 7, this.field_147000_g);
        for (int i = 0; i < this.bgRpt; ++i) {
            this.func_238474_b_(matrix, left + 7 + i * 5, top, 7, 0, 5, this.field_147000_g);
        }
        int x = left + 7 + 5 * this.bgRpt + this.rBdrCor;
        this.func_238474_b_(matrix, x, top, 12, 0, 7, this.field_147000_g);
        this.func_238474_b_(matrix, x + 7 - 2, top + 5, 0, 188, 25, 68);
    }

    private void drawInputSlots(MatrixStack matrix, int left, int top) {
        this.func_238474_b_(matrix, left + 7 + 18 - 17, top + 7, 62, 0, 18, 18);
        for (int i = 0; i < this.numInputs; ++i) {
            int x = left + this.inputStartX + 18 + i * 36;
            this.func_238474_b_(matrix, x, top + 7, 62, 18, 18, 18);
            this.func_238474_b_(matrix, x, top + 7 + 18, 80, 0, 18, 18);
            int scaledProgress = 16 * ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getTime(i) / ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getTotalTime(i);
            this.func_238474_b_(matrix, x, top + 7 + 18, 80, 18, 18, scaledProgress);
        }
    }

    private void drawOutputSlots(MatrixStack matrix, int left, int top) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.numInputs * 2; ++j) {
                int x = left + this.outputStartX + 18 + j * 18;
                int y = top + 7 + 36 + i * 18;
                this.func_238474_b_(matrix, x, y, 62, 18, 18, 18);
            }
        }
    }

    private void drawPowerBar(MatrixStack matrix, int left, int top) {
        this.func_238474_b_(matrix, left + 9, top + 37, 18, 0, 14, 60);
        int scaledRF = 58 * ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getEnergy() / ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getMaxEnergy();
        this.func_238474_b_(matrix, left + 10, top + 38 + (58 - scaledRF), 32, 58 - scaledRF, 12, scaledRF);
    }

    private void drawInventorySlots(MatrixStack matrix, int left, int top) {
        int xStart = left + (int)((double)this.screenWidth * 0.5) - 82;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_238474_b_(matrix, xStart + j * 18, top + 103 + i * 18, 62, 18, 18, 18);
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_238474_b_(matrix, xStart + k * 18, top + 103 + 58, 62, 18, 18, 18);
        }
    }

    private void drawFluidTanks(MatrixStack matrix, int left, int top) {
        if (this.field_230706_i_ != null) {
            int x = left + 7 + 18;
            int y = top + 7 + 36;
            this.drawFluid(0, x - 17, y + 65, matrix, this.field_230706_i_);
            for (int i = 0; i < this.numInputs; ++i) {
                x = left + this.outputStartX + 18 + 9 + i * 36;
                this.drawFluid(i + 1, x, y, matrix, this.field_230706_i_);
            }
        }
    }

    private void drawFluid(int tank, int x, int y, MatrixStack matrix, Minecraft client) {
        this.func_238474_b_(matrix, x, y, 44, 0, 18, 54);
        FluidStack fluidStack = ((CentrifugeMultiblockContainerTier5)this.field_147002_h).getFluidInTank(tank);
        if (fluidStack != FluidStack.EMPTY) {
            TextureAtlasSprite fluidSprite = RenderUtils.getStillFluidTexture((FluidStack)fluidStack);
            int scale = this.getScaledFluidAmount(tank);
            Color color = new Color(fluidStack.getFluid().getAttributes().getColor(fluidStack));
            RenderSystem.color4f((float)color.getR(), (float)color.getG(), (float)color.getB(), (float)color.getAlpha());
            RenderUtils.drawTiledSprite((MatrixStack)matrix, (int)(x + 1), (int)(y + 1), (int)52, (int)16, (int)scale, (TextureAtlasSprite)fluidSprite, (int)16, (int)16, (int)this.func_230927_p_());
            RenderUtils.resetColor();
        }
        client.func_110434_K().func_110577_a(BACKGROUND);
    }

    private int getScaledFluidAmount(int tank) {
        float scale = (float)((CentrifugeMultiblockContainerTier5)this.field_147002_h).getFluidAmountInTank(tank) / (float)((CentrifugeMultiblockContainerTier5)this.field_147002_h).getMaxTankCapacity();
        return Math.round(scale * 52.0f);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (Screen.func_231172_r_() && ((CentrifugeMultiblockContainerTier5)this.field_147002_h).shouldDisplayFluids()) {
            int x = this.field_147003_i + 7 + 18;
            int y = this.field_147009_r + 7 + 36;
            if (MathUtils.inRangeInclusive((double)mouseX, (double)x, (double)(x + 18)) && MathUtils.inRangeInclusive((double)mouseY, (double)y, (double)(y + 54))) {
                NetPacketHandler.sendToServer((Object)new DrainCentrifugeTankMessage(((CentrifugeMultiblockContainerTier5)this.field_147002_h).getCentrifugeTileEntity().func_174877_v(), 0));
                return true;
            }
            for (int i = 0; i < this.numInputs; ++i) {
                x = this.field_147003_i + this.outputStartX + 18 + 9 + i * 36;
                if (!MathUtils.inRangeInclusive((double)mouseX, (double)x, (double)(x + 18)) || !MathUtils.inRangeInclusive((double)mouseY, (double)y, (double)(y + 54))) continue;
                NetPacketHandler.sendToServer((Object)new DrainCentrifugeTankMessage(((CentrifugeMultiblockContainerTier5)this.field_147002_h).getCentrifugeTileEntity().func_174877_v(), i + 1));
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void renderFluidToolTip(MatrixStack matrix, int mouseX, int mouseY, FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            ArrayList<Object> componentList = new ArrayList<Object>();
            componentList.add(new StringTextComponent(this.formatFluidAmount(fluidStack.getAmount())));
            componentList.add(fluidStack.getDisplayName());
            componentList.add(new StringTextComponent(ModConstants.NAMESPACE_FORMATTING + this.getFluidNamespace(fluidStack.getFluid())));
            this.func_243308_b(matrix, componentList, mouseX, mouseY);
        }
    }

    public String formatFluidAmount(int amount) {
        return Screen.func_231173_s_() || amount < 500 ? amount + "mb" : ModConstants.DECIMAL_FORMAT.format(amount / 1000) + "B";
    }

    public String getFluidNamespace(@Nonnull Fluid fluid) {
        return WordUtils.capitalize((String)Objects.requireNonNull(fluid.getRegistryName()).func_110624_b());
    }
}

