/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.IMEAdaptorIterator;
import appeng.util.inv.ItemSlot;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.minecraft.item.ItemStack;

public class IMEAdaptor
extends InventoryAdaptor {
    private final IMEInventory<IAEItemStack> target;
    private final IActionSource src;
    private int maxSlots = 0;

    public IMEAdaptor(IMEInventory<IAEItemStack> input, IActionSource src) {
        this.target = input;
        this.src = src;
    }

    @Override
    public boolean hasSlots() {
        return true;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new IMEAdaptorIterator(this, this.getList());
    }

    private IItemList<IAEItemStack> getList() {
        return this.target.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.doRemoveItems(amount, filter, destination, Actionable.MODULATE);
    }

    private ItemStack doRemoveItems(int amount, ItemStack filter, IInventoryDestination destination, Actionable type) {
        IAEItemStack req = null;
        if (filter.func_190926_b()) {
            IItemList<IAEItemStack> list = this.getList();
            if (!list.isEmpty()) {
                req = list.getFirstItem();
            }
        } else {
            req = AEItemStack.fromItemStack(filter);
        }
        IAEItemStack out = null;
        if (req != null) {
            req.setStackSize(amount);
            out = this.target.extractItems(req, type, this.src);
        }
        if (out != null) {
            return out.createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.doRemoveItems(amount, filter, destination, Actionable.SIMULATE);
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        if (filter.func_190926_b()) {
            return this.doRemoveItems(amount, null, destination, Actionable.MODULATE);
        }
        return this.doRemoveItemsFuzzy(amount, filter, destination, Actionable.MODULATE, fuzzyMode);
    }

    private ItemStack doRemoveItemsFuzzy(int amount, ItemStack filter, IInventoryDestination destination, Actionable type, FuzzyMode fuzzyMode) {
        AEItemStack reqFilter = AEItemStack.fromItemStack(filter);
        if (reqFilter == null) {
            return ItemStack.field_190927_a;
        }
        IAEItemStack out = null;
        for (IAEItemStack req : ImmutableList.copyOf(this.getList().findFuzzy(reqFilter, fuzzyMode))) {
            if (req == null) continue;
            req.setStackSize(amount);
            out = this.target.extractItems(req, type, this.src);
            if (out == null) continue;
            return out.createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        if (filter.func_190926_b()) {
            return this.doRemoveItems(amount, ItemStack.field_190927_a, destination, Actionable.SIMULATE);
        }
        return this.doRemoveItemsFuzzy(amount, filter, destination, Actionable.SIMULATE, fuzzyMode);
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        IAEItemStack out;
        AEItemStack in = AEItemStack.fromItemStack(toBeAdded);
        if (in != null && (out = this.target.injectItems(in, Actionable.MODULATE, this.src)) != null) {
            return out.createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        IAEItemStack out;
        AEItemStack in = AEItemStack.fromItemStack(toBeSimulated);
        if (in != null && (out = this.target.injectItems(in, Actionable.SIMULATE, this.src)) != null) {
            return out.createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean containsItems() {
        return !this.getList().isEmpty();
    }

    int getMaxSlots() {
        return this.maxSlots;
    }

    void setMaxSlots(int maxSlots) {
        this.maxSlots = maxSlots;
    }
}

