/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemHandlerIterator;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class AdaptorItemHandler
extends InventoryAdaptor {
    protected final IItemHandler itemHandler;

    public AdaptorItemHandler(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public boolean hasSlots() {
        return this.itemHandler.getSlots() > 0;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack rv = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack extracted;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter) || destination != null && ((extracted = this.itemHandler.extractItem(slot, amount, true)).func_190926_b() || !destination.canInsert(extracted)) || (extracted = this.itemHandler.extractItem(slot, amount, false)).func_190926_b()) continue;
            if (rv.func_190926_b()) {
                rv = extracted;
                filter = extracted;
            } else {
                rv.func_190917_f(extracted.func_190916_E());
            }
            amount -= extracted.func_190916_E();
        }
        return rv;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack rv = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack extracted;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter) || (extracted = this.itemHandler.extractItem(slot, amount, true)).func_190926_b() || destination != null && !destination.canInsert(extracted)) continue;
            if (rv.func_190926_b()) {
                rv = extracted.func_77946_l();
                filter = extracted;
            } else {
                rv.func_190917_f(extracted.func_190916_E());
            }
            amount -= extracted.func_190916_E();
        }
        return rv;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack extracted = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && extracted.func_190926_b(); ++slot) {
            ItemStack simulated;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode) || destination != null && ((simulated = this.itemHandler.extractItem(slot, amount, true)).func_190926_b() || !destination.canInsert(simulated))) continue;
            extracted = this.itemHandler.extractItem(slot, amount, false);
        }
        return extracted;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack extracted = ItemStack.field_190927_a;
        for (int slot = 0; slot < slots && extracted.func_190926_b(); ++slot) {
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode) || (extracted = this.itemHandler.extractItem(slot, amount, true)).func_190926_b() || destination == null || destination.canInsert(extracted)) continue;
            extracted = ItemStack.field_190927_a;
        }
        return extracted;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, false);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.addItems(toBeSimulated, true);
    }

    protected ItemStack addItems(ItemStack itemsToAdd, boolean simulate) {
        if (itemsToAdd.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack left = itemsToAdd.func_77946_l();
        for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            if (!(left = this.itemHandler.insertItem(slot, left, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return left;
    }

    @Override
    public boolean containsItems() {
        int slots = this.itemHandler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (this.itemHandler.getStackInSlot(slot).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new ItemHandlerIterator(this.itemHandler);
    }
}

