/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.recipes.handlers.GrinderOptionalResult;
import appeng.recipes.handlers.GrinderRecipe;
import appeng.recipes.handlers.GrinderRecipes;
import appeng.tile.AEBaseInvTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class GrinderTileEntity
extends AEBaseInvTileEntity
implements ICrankable {
    private static final int SLOT_PROCESSING = 6;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 7);
    private final IItemHandler invExt = new WrapperFilteredItemHandler((IItemHandler)this.inv, new GrinderFilter());
    private int points;

    public GrinderTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        state.func_177230_c().func_220069_a(state, this.field_145850_b, this.field_174879_c, state.func_177230_c(), this.field_174879_c, false);
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    protected IItemHandler getItemHandlerForSide(Direction side) {
        return this.invExt;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public boolean canTurn() {
        if (this.isRemote()) {
            return false;
        }
        if (this.inv.getStackInSlot(6).func_190926_b()) {
            for (int x = 0; x < 3; ++x) {
                GrinderRecipe r;
                ItemStack item = this.inv.getStackInSlot(x);
                if (item.func_190926_b() || (r = GrinderRecipes.findForInput(this.field_145850_b, item)) == null) continue;
                ItemStack ais = item.func_77946_l();
                ais.func_190920_e(r.getIngredientCount());
                item.func_190918_g(r.getIngredientCount());
                if (item.func_190916_E() <= 0) {
                    item = ItemStack.field_190927_a;
                }
                this.inv.setStackInSlot(x, item);
                this.inv.setStackInSlot(6, ais);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyTurn() {
        if (this.isRemote()) {
            return;
        }
        ++this.points;
        ItemStack processing = this.inv.getStackInSlot(6);
        GrinderRecipe r = GrinderRecipes.findForInput(this.field_145850_b, processing);
        if (r != null) {
            if (r.getTurns() > this.points) {
                return;
            }
            this.points = 0;
            AdaptorItemHandler sia = new AdaptorItemHandler((IItemHandler)new RangedWrapper((IItemHandlerModifiable)this.inv, 3, 6));
            this.addItem(sia, r.func_77571_b());
            for (GrinderOptionalResult optionalResult : r.getOptionalResults()) {
                float chance = (float)(Platform.getRandomInt() % 2000) / 2000.0f;
                if (!(chance <= optionalResult.getChance())) continue;
                this.addItem(sia, optionalResult.getResult());
            }
            this.inv.setStackInSlot(6, ItemStack.field_190927_a);
        }
    }

    private void addItem(InventoryAdaptor sia, ItemStack output) {
        if (output.func_190926_b()) {
            return;
        }
        ItemStack notAdded = sia.addItems(output);
        if (!notAdded.func_190926_b()) {
            ArrayList<ItemStack> out = new ArrayList<ItemStack>();
            out.add(notAdded);
            Platform.spawnDrops(this.field_145850_b, this.field_174879_c.func_177972_a(this.getForward()), out);
        }
    }

    @Override
    public boolean canCrankAttach(Direction directionToCrank) {
        return this.getUp() == directionToCrank;
    }

    private class GrinderFilter
    implements IAEItemFilter {
        private GrinderFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slotIndex, int amount) {
            return slotIndex >= 3 && slotIndex <= 5;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slotIndex, ItemStack stack) {
            if (!GrinderRecipes.isValidIngredient(GrinderTileEntity.this.field_145850_b, stack)) {
                return false;
            }
            return slotIndex >= 0 && slotIndex <= 2;
        }
    }
}

