/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.spatial.TransitionInfo;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class SpatialStoragePlot {
    private static final String TAG_ID = "id";
    private static final String TAG_SIZE = "size";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_LAST_TRANSITION = "last_transition";
    private static final int REGION_SIZE = 512;
    public static final int MAX_SIZE = 128;
    private final int id;
    private final BlockPos size;
    private final int owner;
    @Nullable
    private TransitionInfo lastTransition;

    public SpatialStoragePlot(int id, BlockPos size, int owner) {
        this.id = id;
        this.size = size;
        this.owner = owner;
        if (size.func_177958_n() < 1 || size.func_177956_o() < 1 || size.func_177952_p() < 1) {
            throw new IllegalArgumentException("Plot size " + size + " is smaller than minimum size.");
        }
        if (size.func_177958_n() > 128 || size.func_177956_o() > 128 || size.func_177952_p() > 128) {
            throw new IllegalArgumentException("Plot size " + size + " exceeds maximum size of " + 128);
        }
    }

    public int getId() {
        return this.id;
    }

    public BlockPos getSize() {
        return this.size;
    }

    public int getOwner() {
        return this.owner;
    }

    @Nullable
    public TransitionInfo getLastTransition() {
        return this.lastTransition;
    }

    void setLastTransition(TransitionInfo info) {
        this.lastTransition = info;
    }

    public BlockPos getOrigin() {
        int signBits = this.id & 3;
        int offsetBits = this.id >> 2;
        int offsetScale = 1;
        int posx = 256;
        int posz = 256;
        while (offsetBits != 0) {
            posx += 512 * offsetScale * (offsetBits & 1);
            posz += 512 * offsetScale * (offsetBits >> 1 & 1);
            offsetBits >>= 2;
            offsetScale <<= 1;
        }
        if ((signBits & 1) != 0) {
            posz *= -1;
        }
        if ((signBits & 2) != 0) {
            posx *= -1;
        }
        return new BlockPos(posx -= 64, 64, posz -= 64);
    }

    public String getRegionFilename() {
        BlockPos origin = this.getOrigin();
        ChunkPos originChunk = new ChunkPos(origin);
        return String.format(Locale.ROOT, "r.%d.%d.mca", originChunk.func_222241_h(), originChunk.func_222242_i());
    }

    public CompoundNBT toTag() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(TAG_ID, this.id);
        tag.func_218657_a(TAG_SIZE, (INBT)NBTUtil.func_186859_a((BlockPos)this.size));
        tag.func_74768_a(TAG_OWNER, this.owner);
        if (this.lastTransition != null) {
            tag.func_218657_a(TAG_LAST_TRANSITION, (INBT)this.lastTransition.toTag());
        }
        return tag;
    }

    public static SpatialStoragePlot fromTag(CompoundNBT tag) {
        int id = tag.func_74762_e(TAG_ID);
        BlockPos size = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(TAG_SIZE));
        int ownerId = tag.func_74762_e(TAG_OWNER);
        SpatialStoragePlot plot = new SpatialStoragePlot(id, size, ownerId);
        if (tag.func_150297_b(TAG_LAST_TRANSITION, 10)) {
            plot.lastTransition = TransitionInfo.fromTag(tag.func_74775_l(TAG_LAST_TRANSITION));
        }
        return plot;
    }
}

