/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.util.WorldCoord;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.spatial.CachedPlane;
import appeng.spatial.ISpatialVisitor;
import appeng.spatial.SpatialStorageDimensionIds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class SpatialStorageHelper {
    private static SpatialStorageHelper instance;

    public static SpatialStorageHelper getInstance() {
        if (instance == null) {
            instance = new SpatialStorageHelper();
        }
        return instance;
    }

    private Entity teleportEntity(Entity entity, TelDestination link) {
        ServerWorld newWorld;
        ServerWorld oldWorld;
        try {
            oldWorld = (ServerWorld)entity.field_70170_p;
            newWorld = link.dim;
        }
        catch (Throwable e) {
            return entity;
        }
        if (oldWorld == null) {
            return entity;
        }
        if (newWorld == null) {
            return entity;
        }
        if (newWorld == oldWorld) {
            return entity;
        }
        if (entity.func_184218_aH()) {
            return this.teleportEntity(entity.func_184187_bx(), link);
        }
        List passengers = entity.func_184188_bt();
        ArrayList<Entity> passengersOnOtherSide = new ArrayList<Entity>(passengers.size());
        for (Entity passenger : passengers) {
            passenger.func_184210_p();
            passengersOnOtherSide.add(this.teleportEntity(passenger, link));
        }
        newWorld.func_72863_F().func_212849_a_(MathHelper.func_76128_c((double)link.x) >> 4, MathHelper.func_76128_c((double)link.z) >> 4, ChunkStatus.field_222617_m, true);
        if (entity instanceof ServerPlayerEntity && link.dim.func_234923_W_() == SpatialStorageDimensionIds.WORLD_ID) {
            AppEng.instance().getAdvancementTriggers().getSpatialExplorer().trigger((ServerPlayerEntity)entity);
        }
        final PortalInfo portalInfo = new PortalInfo(new Vector3d(link.x, link.y, link.z), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
        if ((entity = entity.changeDimension(link.dim, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                return repositionEntity.apply(false);
            }

            public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
                return portalInfo;
            }
        })) != null && !passengersOnOtherSide.isEmpty()) {
            for (Entity passanger : passengersOnOtherSide) {
                passanger.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    private void transverseEdges(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, ISpatialVisitor visitor) {
        int x;
        int z;
        for (int y = minY; y < maxY; ++y) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new BlockPos(minX, y, z));
                visitor.visit(new BlockPos(maxX, y, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new BlockPos(x, minY, z));
                visitor.visit(new BlockPos(x, maxY, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                visitor.visit(new BlockPos(x, y, minZ));
                visitor.visit(new BlockPos(x, y, maxZ));
            }
        }
    }

    public void swapRegions(ServerWorld srcWorld, int srcX, int srcY, int srcZ, ServerWorld dstWorld, int dstX, int dstY, int dstZ, int scaleX, int scaleY, int scaleZ) {
        Api.instance().definitions().blocks().matrixFrame().maybeBlock().ifPresent(matrixFrameBlock -> this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new WrapInMatrixFrame(matrixFrameBlock.func_176223_P(), (World)dstWorld)));
        AxisAlignedBB srcBox = new AxisAlignedBB((double)srcX, (double)srcY, (double)srcZ, (double)(srcX + scaleX + 1), (double)(srcY + scaleY + 1), (double)(srcZ + scaleZ + 1));
        AxisAlignedBB dstBox = new AxisAlignedBB((double)dstX, (double)dstY, (double)dstZ, (double)(dstX + scaleX + 1), (double)(dstY + scaleY + 1), (double)(dstZ + scaleZ + 1));
        CachedPlane cDst = new CachedPlane(dstWorld, dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ);
        CachedPlane cSrc = new CachedPlane(srcWorld, srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ);
        cSrc.swap(cDst);
        List srcE = srcWorld.func_217357_a(Entity.class, srcBox);
        List dstE = dstWorld.func_217357_a(Entity.class, dstBox);
        for (Entity e : dstE) {
            this.teleportEntity(e, new TelDestination(srcWorld, srcBox, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), -dstX + srcX, -dstY + srcY, -dstZ + srcZ));
        }
        for (Entity e : srcE) {
            this.teleportEntity(e, new TelDestination(dstWorld, dstBox, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), -srcX + dstX, -srcY + dstY, -srcZ + dstZ));
        }
        for (WorldCoord wc : cDst.getUpdates()) {
            cSrc.getWorld().func_195593_d(wc.getPos(), Blocks.field_150350_a);
        }
        for (WorldCoord wc : cSrc.getUpdates()) {
            cSrc.getWorld().func_195593_d(wc.getPos(), Blocks.field_150350_a);
        }
        this.transverseEdges(srcX - 1, srcY - 1, srcZ - 1, srcX + scaleX + 1, srcY + scaleY + 1, srcZ + scaleZ + 1, new TriggerUpdates((World)srcWorld));
        this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new TriggerUpdates((World)dstWorld));
        this.transverseEdges(srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ, new TriggerUpdates((World)srcWorld));
        this.transverseEdges(dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ, new TriggerUpdates((World)dstWorld));
    }

    private static class TelDestination {
        private final ServerWorld dim;
        private final double x;
        private final double y;
        private final double z;

        TelDestination(ServerWorld dimension, AxisAlignedBB srcBox, double x, double y, double z, int tileX, int tileY, int tileZ) {
            this.dim = dimension;
            this.x = Math.min(srcBox.field_72336_d - 0.5, Math.max(srcBox.field_72340_a + 0.5, x + (double)tileX));
            this.y = Math.min(srcBox.field_72337_e - 0.5, Math.max(srcBox.field_72338_b + 0.5, y + (double)tileY));
            this.z = Math.min(srcBox.field_72334_f - 0.5, Math.max(srcBox.field_72339_c + 0.5, z + (double)tileZ));
        }
    }

    private static class WrapInMatrixFrame
    implements ISpatialVisitor {
        private final World dst;
        private final BlockState state;

        public WrapInMatrixFrame(BlockState state, World dst2) {
            this.dst = dst2;
            this.state = state;
        }

        @Override
        public void visit(BlockPos pos) {
            this.dst.func_175656_a(pos, this.state);
        }
    }

    private static class TriggerUpdates
    implements ISpatialVisitor {
        private final World dst;

        public TriggerUpdates(World dst2) {
            this.dst = dst2;
        }

        @Override
        public void visit(BlockPos pos) {
            BlockState state = this.dst.func_180495_p(pos);
            Block blk = state.func_177230_c();
            blk.func_220069_a(state, this.dst, pos, blk, pos, false);
        }
    }
}

