/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class DisassembleRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<DisassembleRecipe> SERIALIZER = new SpecialRecipeSerializer(DisassembleRecipe::new);
    private static final ItemStack MISMATCHED_STACK;
    private final Map<IItemDefinition, IItemDefinition> cellMappings;
    private final Map<IItemDefinition, IItemDefinition> nonCellMappings;

    public DisassembleRecipe(ResourceLocation id) {
        super(id);
        IDefinitions definitions = Api.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IItems items = definitions.items();
        IMaterials mats = definitions.materials();
        this.cellMappings = new HashMap<IItemDefinition, IItemDefinition>(4);
        this.nonCellMappings = new HashMap<IItemDefinition, IItemDefinition>(5);
        this.cellMappings.put(items.cell1k(), mats.cell1kPart());
        this.cellMappings.put(items.cell4k(), mats.cell4kPart());
        this.cellMappings.put(items.cell16k(), mats.cell16kPart());
        this.cellMappings.put(items.cell64k(), mats.cell64kPart());
        this.nonCellMappings.put(items.encodedPattern(), mats.blankPattern());
        this.nonCellMappings.put(blocks.craftingStorage1k(), mats.cell1kPart());
        this.nonCellMappings.put(blocks.craftingStorage4k(), mats.cell4kPart());
        this.nonCellMappings.put(blocks.craftingStorage16k(), mats.cell16kPart());
        this.nonCellMappings.put(blocks.craftingStorage64k(), mats.cell64kPart());
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World w) {
        return !this.getOutput((IInventory)inv).func_190926_b();
    }

    @Nonnull
    private ItemStack getOutput(IInventory inventory) {
        int itemCount = 0;
        ItemStack output = MISMATCHED_STACK;
        for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inventory.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (++itemCount > 1) {
                return MISMATCHED_STACK;
            }
            Optional<ItemStack> maybeCellOutput = this.getCellOutput(stackInSlot);
            if (maybeCellOutput.isPresent()) {
                IItemList list;
                ItemStack storageCellStack = maybeCellOutput.get();
                ICellInventoryHandler<IAEItemStack> cellInv = Api.instance().registries().cell().getCellInventory(stackInSlot, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                if (cellInv != null && !(list = cellInv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList())).isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                output = storageCellStack;
            }
            output = this.getNonCellOutput(stackInSlot).orElse(output);
        }
        return output;
    }

    @Nonnull
    private Optional<ItemStack> getCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.cellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<ItemStack> getNonCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.nonCellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        return this.getOutput((IInventory)inv);
    }

    public boolean func_194133_a(int i, int i1) {
        return false;
    }

    @Nonnull
    public IRecipeSerializer<DisassembleRecipe> func_199559_b() {
        return SERIALIZER;
    }

    static {
        SERIALIZER.setRegistryName(new ResourceLocation("appliedenergistics2", "disassemble"));
        MISMATCHED_STACK = ItemStack.field_190927_a;
    }
}

