/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeBuilder;
import appeng.recipes.entropy.MultipleValuesMatcher;
import appeng.recipes.entropy.RangeValueMatcher;
import appeng.recipes.entropy.SingleValueMatcher;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntropyRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<EntropyRecipe> {
    public static final EntropyRecipeSerializer INSTANCE = new EntropyRecipeSerializer();

    private EntropyRecipeSerializer() {
    }

    public EntropyRecipe read(ResourceLocation recipeId, JsonObject json) {
        JsonObject outputFluidObject;
        String outputFluidId;
        JsonObject outputJson;
        JsonObject outputBlockObject;
        String outputBlockId;
        JsonObject inputFluidObject;
        String inputFluidId;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode(EntropyMode.valueOf(JSONUtils.func_151200_h((JsonObject)json, (String)"mode").toUpperCase(Locale.ROOT)));
        JsonObject inputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        JsonObject inputBlockObject = JSONUtils.func_151218_a((JsonObject)inputJson, (String)"block", (JsonObject)new JsonObject());
        String inputBlockId = JSONUtils.func_151219_a((JsonObject)inputBlockObject, (String)"id", null);
        if (inputBlockId != null) {
            Block block = (Block)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.BLOCKS, inputBlockId);
            builder.setInputBlock(block);
            EntropyRecipeSerializer.parseStateMatchers(block.func_176194_O(), inputBlockObject, builder::addBlockStateMatcher);
        }
        if ((inputFluidId = JSONUtils.func_151219_a((JsonObject)(inputFluidObject = JSONUtils.func_151218_a((JsonObject)inputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Fluid fluid = (Fluid)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.FLUIDS, inputFluidId);
            builder.setInputFluid(fluid);
            EntropyRecipeSerializer.parseStateMatchers(fluid.func_207182_e(), inputFluidObject, builder::addFluidStateMatcher);
        }
        if ((outputBlockId = JSONUtils.func_151219_a((JsonObject)(outputBlockObject = JSONUtils.func_151218_a((JsonObject)(outputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"output")), (String)"block", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Block block = (Block)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.BLOCKS, outputBlockId);
            builder.setOutputBlock(block);
            boolean outputBlockKeep = JSONUtils.func_151209_a((JsonObject)outputBlockObject, (String)"keep", (boolean)false);
            builder.setOutputBlockKeep(outputBlockKeep);
            EntropyRecipeSerializer.parseStateAppliers(block.func_176194_O(), outputBlockObject, builder::addBlockStateAppliers);
        }
        if ((outputFluidId = JSONUtils.func_151219_a((JsonObject)(outputFluidObject = JSONUtils.func_151218_a((JsonObject)outputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Fluid fluid = (Fluid)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.FLUIDS, outputFluidId);
            builder.setOutputFluid(fluid);
            boolean outputFluidKeep = JSONUtils.func_151209_a((JsonObject)outputFluidObject, (String)"keep", (boolean)false);
            builder.setOutputFluidKeep(outputFluidKeep);
            EntropyRecipeSerializer.parseStateAppliers(fluid.func_207182_e(), outputFluidObject, builder::addFluidStateAppliers);
        }
        if (outputJson.has("drops")) {
            JsonArray dropList = JSONUtils.func_151214_t((JsonObject)outputJson, (String)"drops");
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(dropList.size());
            for (JsonElement jsonElement : dropList) {
                JsonObject object = jsonElement.getAsJsonObject();
                String itemid = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemid));
                int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
                drops.add(new ItemStack((IItemProvider)item, count));
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    private static <T extends IForgeRegistryEntry<T>> T getRequiredEntry(IForgeRegistry<T> registry, String id) {
        IForgeRegistryEntry entry = registry.getValue(new ResourceLocation(id));
        if (entry == null) {
            throw new IllegalArgumentException("Unknown id " + id + " for " + registry.getRegistryName());
        }
        return (T)entry;
    }

    @Nullable
    public EntropyRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        int dropSize;
        int appliersSize;
        Fluid fluid;
        int i;
        int matcherSize;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode((EntropyMode)buffer.func_179257_a(EntropyMode.class));
        if (buffer.readBoolean()) {
            Block inputBlock = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
            builder.setInputBlock(inputBlock);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addBlockStateMatcher(StateMatcher.read(inputBlock.func_176194_O(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
            builder.setInputFluid(fluid);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addFluidStateMatcher(StateMatcher.read(fluid.func_207182_e(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            Block block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
            builder.setOutputBlock(block);
            builder.setOutputBlockKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addBlockStateAppliers(StateApplier.readFromPacket(block.func_176194_O(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
            builder.setOutputFluid(fluid);
            builder.setOutputFluidKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addFluidStateAppliers(StateApplier.readFromPacket(fluid.func_207182_e(), buffer));
            }
        }
        if ((dropSize = buffer.readInt()) > 0) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(dropSize);
            for (i = 0; i < dropSize; ++i) {
                drops.add(buffer.func_150791_c());
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    public void write(PacketBuffer buffer, EntropyRecipe recipe) {
        List<StateApplier<?>> appliers;
        buffer.func_179249_a((Enum)recipe.getMode());
        buffer.writeBoolean(recipe.getInputBlock() != null);
        if (recipe.getInputBlock() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)recipe.getInputBlock());
            List<StateMatcher> inputBlockMatchers = recipe.getInputBlockMatchers();
            buffer.writeInt(inputBlockMatchers.size());
            for (StateMatcher stateMatcher : inputBlockMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getInputFluid() != null);
        if (recipe.getInputFluid() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (IForgeRegistryEntry)recipe.getInputFluid());
            List<StateMatcher> inputFluidMatchers = recipe.getInputFluidMatchers();
            buffer.writeInt(inputFluidMatchers.size());
            for (StateMatcher stateMatcher : inputFluidMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputBlock() != null);
        if (recipe.getOutputBlock() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)recipe.getOutputBlock());
            buffer.writeBoolean(recipe.getOutputBlockKeep());
            appliers = recipe.getOutputBlockStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputFluid() != null);
        if (recipe.getOutputFluid() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (IForgeRegistryEntry)recipe.getOutputFluid());
            buffer.writeBoolean(recipe.getOutputFluidKeep());
            appliers = recipe.getOutputFluidStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeInt(recipe.getDrops().size());
        for (ItemStack itemStack : recipe.getDrops()) {
            buffer.func_150788_a(itemStack);
        }
    }

    private static void parseStateMatchers(StateContainer<?, ?> stateContainer, JsonObject propertiesContainer, Consumer<StateMatcher> consumer) {
        JsonObject properties = JSONUtils.func_151218_a((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value == null) {
                return;
            }
            if (value.isJsonPrimitive()) {
                consumer.accept(SingleValueMatcher.create(stateContainer, key, value.getAsString()));
            } else if (value.isJsonArray()) {
                JsonArray array = value.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (JsonElement e : array) {
                    list.add(e.getAsString());
                }
                consumer.accept(MultipleValuesMatcher.create(stateContainer, key, list));
            } else if (value.isJsonObject() && value.getAsJsonObject().has("min") && value.getAsJsonObject().has("max")) {
                String min = value.getAsJsonObject().get("min").getAsString();
                String max = value.getAsJsonObject().get("max").getAsString();
                consumer.accept(RangeValueMatcher.create(stateContainer, key, min, max));
            } else {
                throw new IllegalArgumentException("Invalid matcher: " + value);
            }
        });
    }

    private static void parseStateAppliers(StateContainer<?, ?> stateContainer, JsonObject propertiesContainer, Consumer<StateApplier<?>> consumer) {
        JsonObject properties = JSONUtils.func_151218_a((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(StateApplier.create(stateContainer, key, value));
        });
    }

    static {
        INSTANCE.setRegistryName(EntropyRecipe.TYPE_ID);
    }
}

