/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.client.render.cablebus.P2PTunnelFrequencyModelData;
import appeng.core.Api;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.BasicStatePart;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.data.IModelData;

public abstract class P2PTunnelPart<T extends P2PTunnelPart>
extends BasicStatePart {
    private final TunnelCollection type = new TunnelCollection(null, this.getClass());
    private boolean output;
    private short freq;

    public P2PTunnelPart(ItemStack is) {
        super(is);
        this.getProxy().setIdlePowerUsage(this.getPowerDrainPerTick());
    }

    protected float getPowerDrainPerTick() {
        return 1.0f;
    }

    public TunnelCollection<T> getCollection(Collection<P2PTunnelPart> collection, Class<? extends P2PTunnelPart> c) {
        if (this.type.matches(c)) {
            this.type.setSource(collection);
            return this.type;
        }
        return null;
    }

    @Nullable
    public T getInput() {
        if (this.getFrequency() == 0) {
            return null;
        }
        try {
            P2PTunnelPart tunnel = this.getProxy().getP2P().getInput(this.getFrequency());
            if (this.getClass().isInstance(tunnel)) {
                return (T)tunnel;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return null;
    }

    public TunnelCollection<T> getOutputs() throws GridAccessException {
        if (this.getProxy().isActive()) {
            return this.getProxy().getP2P().getOutputs(this.getFrequency(), this.getClass());
        }
        return new TunnelCollection(new ArrayList(), this.getClass());
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        if (type == PartItemStack.WORLD || type == PartItemStack.NETWORK || type == PartItemStack.WRENCH || type == PartItemStack.PICK) {
            return super.getItemStack(type);
        }
        Optional<ItemStack> maybeMEStack = Api.instance().definitions().parts().p2PTunnelME().maybeStack(1);
        if (maybeMEStack.isPresent()) {
            return maybeMEStack.get();
        }
        return super.getItemStack(type);
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        super.readFromNBT(data);
        this.setOutput(data.func_74767_n("output"));
        this.freq = data.func_74765_d("freq");
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        super.writeToNBT(data);
        data.func_74757_a("output", this.isOutput());
        data.func_74777_a("freq", this.getFrequency());
    }

    @Override
    public boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        short oldf = this.freq;
        this.freq = data.readShort();
        return c || oldf != this.freq;
    }

    @Override
    public void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeShort((int)this.getFrequency());
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public boolean onPartActivate(PlayerEntity player, Hand hand, Vector3d pos) {
        if (this.isRemote()) {
            return true;
        }
        if (hand == Hand.OFF_HAND) {
            return false;
        }
        ItemStack is = player.func_184586_b(hand);
        TunnelType tt = Api.instance().registries().p2pTunnel().getTunnelTypeByItem(is);
        if (!is.func_190926_b() && is.func_77973_b() instanceof IMemoryCard) {
            Object testPart;
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            CompoundNBT data = mc.getData(is);
            ItemStack newType = ItemStack.func_199557_a((CompoundNBT)data);
            short freq = data.func_74765_d("freq");
            if (!newType.func_190926_b() && newType.func_77973_b() instanceof IPartItem && (testPart = ((IPartItem)newType.func_77973_b()).createPart(newType)) instanceof P2PTunnelPart) {
                this.getHost().removePart(this.getSide(), true);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof P2PTunnelPart) {
                    P2PTunnelPart newTunnel = (P2PTunnelPart)newBus;
                    newTunnel.setOutput(true);
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, freq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    newTunnel.onTunnelNetworkChange();
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (tt != null) {
            ItemStack newType;
            IParts parts = Api.instance().definitions().parts();
            switch (tt) {
                case LIGHT: {
                    newType = parts.p2PTunnelLight().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case FE_POWER: {
                    newType = parts.p2PTunnelFE().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case FLUID: {
                    newType = parts.p2PTunnelFluids().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case IC2_POWER: {
                    newType = parts.p2PTunnelEU().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case ITEM: {
                    newType = parts.p2PTunnelItems().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case ME: {
                    newType = parts.p2PTunnelME().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                case REDSTONE: {
                    newType = parts.p2PTunnelRedstone().maybeStack(1).orElse(ItemStack.field_190927_a);
                    break;
                }
                default: {
                    newType = ItemStack.field_190927_a;
                }
            }
            if (!newType.func_190926_b() && !ItemStack.func_179545_c((ItemStack)newType, (ItemStack)this.getItemStack())) {
                boolean oldOutput = this.isOutput();
                short myFreq = this.getFrequency();
                this.getHost().removePart(this.getSide(), true);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof P2PTunnelPart) {
                    P2PTunnelPart newTunnel = (P2PTunnelPart)newBus;
                    newTunnel.setOutput(oldOutput);
                    newTunnel.onTunnelNetworkChange();
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, myFreq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                Platform.notifyBlocksOfNeighbors(this.getTile().func_145831_w(), this.getTile().func_174877_v());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onPartShiftActivate(PlayerEntity player, Hand hand, Vector3d pos) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!is.func_190926_b() && is.func_77973_b() instanceof IMemoryCard) {
            if (this.isRemote()) {
                return true;
            }
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            CompoundNBT data = mc.getData(is);
            short storedFrequency = data.func_74765_d("freq");
            short newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            boolean needsNewFrequency = wasOutput || this.getFrequency() == 0 || storedFrequency == newFreq;
            try {
                if (needsNewFrequency) {
                    newFreq = this.getProxy().getP2P().newFrequency();
                }
                this.getProxy().getP2P().updateFreq(this, newFreq);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.onTunnelConfigChange();
            ItemStack p2pItem = this.getItemStack(PartItemStack.WRENCH);
            String type = p2pItem.func_77977_a();
            p2pItem.func_77955_b(data);
            data.func_74777_a("freq", this.getFrequency());
            AEColor[] colors = Platform.p2p().toColors(this.getFrequency());
            int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
            data.func_74783_a("colorCode", colorCode);
            mc.setMemoryCardContents(is, type + ".name", data);
            if (needsNewFrequency) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_RESET);
            } else {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            }
            return true;
        }
        return false;
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        try {
            this.getProxy().getEnergy().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public short getFrequency() {
        return this.freq;
    }

    public void setFrequency(short freq) {
        short oldf = this.freq;
        this.freq = freq;
        if (oldf != this.freq) {
            this.getHost().markForUpdate();
        }
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
    }

    @Override
    public IModelData getModelData() {
        long ret = Short.toUnsignedLong(this.getFrequency());
        if (this.isActive() && this.isPowered()) {
            ret |= 0x10000L;
        }
        return new P2PTunnelFrequencyModelData(ret);
    }
}

