/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.parts.IPartCollisionHelper;
import appeng.api.util.AEPartLocation;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;

public class BusCollisionHelper
implements IPartCollisionHelper {
    private final List<AxisAlignedBB> boxes;
    private final Direction x;
    private final Direction y;
    private final Direction z;
    private final boolean isVisual;

    public BusCollisionHelper(List<AxisAlignedBB> boxes, Direction x, Direction y, Direction z, boolean visual) {
        this.boxes = boxes;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isVisual = visual;
    }

    public BusCollisionHelper(List<AxisAlignedBB> boxes, AEPartLocation s, boolean visual) {
        this.boxes = boxes;
        this.isVisual = visual;
        switch (s) {
            case DOWN: {
                this.x = Direction.EAST;
                this.y = Direction.NORTH;
                this.z = Direction.DOWN;
                break;
            }
            case UP: {
                this.x = Direction.EAST;
                this.y = Direction.SOUTH;
                this.z = Direction.UP;
                break;
            }
            case EAST: {
                this.x = Direction.SOUTH;
                this.y = Direction.UP;
                this.z = Direction.EAST;
                break;
            }
            case WEST: {
                this.x = Direction.NORTH;
                this.y = Direction.UP;
                this.z = Direction.WEST;
                break;
            }
            case NORTH: {
                this.x = Direction.WEST;
                this.y = Direction.UP;
                this.z = Direction.NORTH;
                break;
            }
            case SOUTH: {
                this.x = Direction.EAST;
                this.y = Direction.UP;
                this.z = Direction.SOUTH;
                break;
            }
            default: {
                this.x = Direction.EAST;
                this.y = Direction.UP;
                this.z = Direction.SOUTH;
            }
        }
    }

    @Override
    public void addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double aX = (minX /= 16.0) * (double)this.x.func_82601_c() + (minY /= 16.0) * (double)this.y.func_82601_c() + (minZ /= 16.0) * (double)this.z.func_82601_c();
        double aY = minX * (double)this.x.func_96559_d() + minY * (double)this.y.func_96559_d() + minZ * (double)this.z.func_96559_d();
        double aZ = minX * (double)this.x.func_82599_e() + minY * (double)this.y.func_82599_e() + minZ * (double)this.z.func_82599_e();
        double bX = (maxX /= 16.0) * (double)this.x.func_82601_c() + (maxY /= 16.0) * (double)this.y.func_82601_c() + (maxZ /= 16.0) * (double)this.z.func_82601_c();
        double bY = maxX * (double)this.x.func_96559_d() + maxY * (double)this.y.func_96559_d() + maxZ * (double)this.z.func_96559_d();
        double bZ = maxX * (double)this.x.func_82599_e() + maxY * (double)this.y.func_82599_e() + maxZ * (double)this.z.func_82599_e();
        if (this.x.func_82601_c() + this.y.func_82601_c() + this.z.func_82601_c() < 0) {
            aX += 1.0;
            bX += 1.0;
        }
        if (this.x.func_96559_d() + this.y.func_96559_d() + this.z.func_96559_d() < 0) {
            aY += 1.0;
            bY += 1.0;
        }
        if (this.x.func_82599_e() + this.y.func_82599_e() + this.z.func_82599_e() < 0) {
            aZ += 1.0;
            bZ += 1.0;
        }
        minX = Math.min(aX, bX);
        minY = Math.min(aY, bY);
        minZ = Math.min(aZ, bZ);
        maxX = Math.max(aX, bX);
        maxY = Math.max(aY, bY);
        maxZ = Math.max(aZ, bZ);
        this.boxes.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
    }

    @Override
    public Direction getWorldX() {
        return this.x;
    }

    @Override
    public Direction getWorldY() {
        return this.y;
    }

    @Override
    public Direction getWorldZ() {
        return this.z;
    }

    @Override
    public boolean isBBCollision() {
        return !this.isVisual;
    }
}

