/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.helpers;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkPowerIdleChange;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IOrientable;
import appeng.core.Api;
import appeng.core.worlddata.WorldData;
import appeng.hooks.ticking.TickHandler;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.StatisticsCache;
import appeng.me.helpers.IGridProxyable;
import appeng.parts.networking.CablePart;
import appeng.tile.AEBaseTileEntity;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public class AENetworkProxy
implements IGridBlock {
    private final IGridProxyable gp;
    private final boolean isWorldAccessible;
    private final String nbtName;
    private AEColor myColor = AEColor.TRANSPARENT;
    private CompoundNBT data = null;
    private ItemStack myRepInstance;
    private boolean isReady = false;
    private IGridNode node = null;
    private EnumSet<Direction> validSides = EnumSet.allOf(Direction.class);
    private EnumSet<GridFlags> flags = EnumSet.noneOf(GridFlags.class);
    private double idleDraw = 1.0;
    private PlayerEntity owner;

    public AENetworkProxy(IGridProxyable te, String nbtName, ItemStack visual, boolean inWorld) {
        this.gp = Objects.requireNonNull(te);
        this.nbtName = Objects.requireNonNull(nbtName);
        this.isWorldAccessible = inWorld;
        this.myRepInstance = Objects.requireNonNull(visual);
    }

    public void setVisualRepresentation(ItemStack is) {
        this.myRepInstance = Objects.requireNonNull(is);
    }

    public void writeToNBT(CompoundNBT tag) {
        if (this.node != null) {
            this.node.saveToNBT(this.nbtName, tag);
        }
    }

    public void setValidSides(EnumSet<Direction> validSides) {
        this.validSides = validSides;
        if (this.node != null) {
            this.node.updateState();
        }
    }

    public void validate() {
        if (this.gp instanceof AEBaseTileEntity) {
            TickHandler.instance().addInit((AEBaseTileEntity)((Object)this.gp));
        }
    }

    public void onChunkUnloaded() {
        this.isReady = false;
        this.remove();
    }

    public void remove() {
        this.isReady = false;
        if (this.node != null) {
            this.node.destroy();
            this.node = null;
        }
    }

    public void onReady() {
        IOrientable ori;
        this.isReady = true;
        if (this.gp instanceof IOrientable && (ori = (IOrientable)((Object)this.gp)).canBeRotated()) {
            ori.setOrientation(ori.getForward(), ori.getUp());
        }
        this.getNode();
    }

    public IGridNode getNode() {
        if (this.node == null && Platform.isServer() && this.isReady) {
            this.node = Api.instance().grid().createGridNode(this);
            this.readFromNBT(this.data);
            this.node.updateState();
        }
        return this.node;
    }

    public void readFromNBT(CompoundNBT tag) {
        this.data = tag;
        if (this.node != null && this.data != null) {
            this.node.loadFromNBT(this.nbtName, this.data);
            this.data = null;
        } else if (this.node != null && this.owner != null) {
            GameProfile profile = this.owner.func_146103_bH();
            int playerID = WorldData.instance().playerData().getMePlayerId(profile);
            this.node.setPlayerID(playerID);
            this.owner = null;
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return this.idleDraw;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return this.flags;
    }

    @Override
    public boolean isWorldAccessible() {
        return this.isWorldAccessible;
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.gp.getLocation();
    }

    @Override
    public AEColor getGridColor() {
        return this.getColor();
    }

    @Override
    public void onGridNotification(GridNotification notification) {
        if (notification == GridNotification.OWNER_CHANGED) {
            this.gp.saveChanges();
            return;
        }
        if (this.gp instanceof CablePart) {
            ((CablePart)this.gp).markForUpdate();
        }
    }

    @Override
    public EnumSet<Direction> getConnectableSides() {
        return this.validSides;
    }

    @Override
    public IGridHost getMachine() {
        return this.gp;
    }

    @Override
    public void gridChanged() {
        this.gp.gridChanged();
    }

    @Override
    public ItemStack getMachineRepresentation() {
        return this.myRepInstance;
    }

    public void setFlags(GridFlags ... requireChannel) {
        EnumSet<GridFlags> flags = EnumSet.noneOf(GridFlags.class);
        Collections.addAll(flags, requireChannel);
        this.flags = flags;
    }

    public void setIdlePowerUsage(double idle) {
        this.idleDraw = idle;
        if (this.node != null) {
            try {
                IGrid g = this.getGrid();
                g.postEvent(new MENetworkPowerIdleChange(this.node));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean isActive() {
        if (this.node == null) {
            return false;
        }
        return this.node.isActive();
    }

    public boolean isPowered() {
        try {
            return this.getEnergy().isNetworkPowered();
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public void setOwner(PlayerEntity player) {
        this.owner = player;
    }

    public AEColor getColor() {
        return this.myColor;
    }

    public void setColor(AEColor myColor) {
        this.myColor = Objects.requireNonNull(myColor);
    }

    @Nonnull
    public IGrid getGrid() throws GridAccessException {
        if (this.node == null) {
            throw new GridAccessException();
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        return grid;
    }

    @Nonnull
    public IPathingGrid getPath() throws GridAccessException {
        return this.getGridCache(IPathingGrid.class);
    }

    @Nonnull
    public ITickManager getTick() throws GridAccessException {
        return this.getGridCache(ITickManager.class);
    }

    @Nonnull
    public IStorageGrid getStorage() throws GridAccessException {
        return this.getGridCache(IStorageGrid.class);
    }

    @Nonnull
    public P2PCache getP2P() throws GridAccessException {
        return this.getGridCache(P2PCache.class);
    }

    @Nonnull
    public ISecurityGrid getSecurity() throws GridAccessException {
        return this.getGridCache(ISecurityGrid.class);
    }

    @Nonnull
    public ICraftingGrid getCrafting() throws GridAccessException {
        return this.getGridCache(ICraftingGrid.class);
    }

    @Nonnull
    public StatisticsCache getStatistics() throws GridAccessException {
        return this.getGridCache(StatisticsCache.class);
    }

    @Nonnull
    public IEnergyGrid getEnergy() throws GridAccessException {
        return this.getGridCache(IEnergyGrid.class);
    }

    @Nonnull
    private <T extends IGridCache> T getGridCache(Class<T> clazz) throws GridAccessException {
        return (T)this.getGrid().getCache(clazz);
    }
}

