/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.util.AEColor;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;

public class PaintBallItemRendering
extends ItemRenderingCustomizer {
    private final boolean lumen;
    private final AEColor color;

    public PaintBallItemRendering(AEColor color, boolean lumen) {
        this.lumen = lumen;
        this.color = color;
    }

    @Override
    public void customize(IItemRendering rendering) {
        int renderColor;
        int colorValue = this.lumen ? this.color.mediumVariant : this.color.mediumVariant;
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        if (this.lumen) {
            float fail = 0.7f;
            int full = 76;
            renderColor = (int)(76.0f + (float)r * 0.7f) << 16 | (int)(76.0f + (float)g * 0.7f) << 8 | (int)(76.0f + (float)b * 0.7f) | 0xFF000000;
        } else {
            renderColor = r << 16 | g << 8 | b | 0xFF000000;
        }
        rendering.color((is, tintIndex) -> renderColor);
    }
}

