/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.materials;

import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.items.AEBaseItem;
import appeng.items.materials.MaterialType;
import appeng.util.InteractionUtil;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.AdaptorItemHandler;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public final class MaterialItem
extends AEBaseItem
implements IStorageComponent,
IUpgradeModule {
    public static final String TAG_INSCRIBE_NAME = "InscribeName";
    private static final int KILO_SCALAR = 1024;
    private final MaterialType materialType;

    public MaterialItem(Item.Properties properties, MaterialType materialType) {
        super(properties);
        this.materialType = materialType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        Upgrades u;
        CompoundNBT c;
        super.func_77624_a(stack, world, lines, advancedTooltips);
        if (this.materialType == MaterialType.NAME_PRESS && (c = stack.func_196082_o()).func_74764_b(TAG_INSCRIBE_NAME)) {
            lines.add((ITextComponent)new StringTextComponent(c.func_74779_i(TAG_INSCRIBE_NAME)));
        }
        if ((u = this.getType(stack)) != null) {
            lines.addAll(u.getTooltipLines());
        }
    }

    @Override
    public Upgrades getType(ItemStack itemstack) {
        switch (this.materialType) {
            case CARD_CAPACITY: {
                return Upgrades.CAPACITY;
            }
            case CARD_FUZZY: {
                return Upgrades.FUZZY;
            }
            case CARD_REDSTONE: {
                return Upgrades.REDSTONE;
            }
            case CARD_SPEED: {
                return Upgrades.SPEED;
            }
            case CARD_INVERTER: {
                return Upgrades.INVERTER;
            }
            case CARD_CRAFTING: {
                return Upgrades.CRAFTING;
            }
        }
        return null;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        if (InteractionUtil.isInAlternateUseMode(player)) {
            IUpgradeModule um;
            Upgrades u;
            TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
            IItemHandler upgrades = null;
            if (te instanceof IPartHost) {
                SelectedPart sp = ((IPartHost)te).selectPart(context.func_221532_j());
                if (sp.part instanceof IUpgradeableHost) {
                    upgrades = ((ISegmentedInventory)((Object)sp.part)).getInventoryByName("upgrades");
                }
            } else if (te instanceof IUpgradeableHost) {
                upgrades = ((ISegmentedInventory)te).getInventoryByName("upgrades");
            }
            if (upgrades != null && !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof IUpgradeModule && (u = (um = (IUpgradeModule)player.func_184586_b(hand).func_77973_b()).getType(player.func_184586_b(hand))) != null) {
                if (player.func_130014_f_().func_201670_d()) {
                    return ActionResultType.PASS;
                }
                AdaptorItemHandler ad = new AdaptorItemHandler(upgrades);
                player.func_184611_a(hand, ((InventoryAdaptor)ad).addItems(player.func_184586_b(hand)));
                return ActionResultType.func_233537_a_((boolean)player.func_130014_f_().func_201670_d());
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public boolean hasCustomEntity(ItemStack is) {
        return this.materialType.hasCustomEntity();
    }

    public Entity createEntity(World w, Entity location, ItemStack itemstack) {
        Entity eqi;
        Class<? extends Entity> droppedEntity = this.materialType.getCustomEntityClass();
        try {
            eqi = droppedEntity.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, ItemStack.class).newInstance(w, location.func_226277_ct_(), location.func_226278_cu_(), location.func_226281_cx_(), itemstack);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        eqi.func_213317_d(location.func_213322_ci());
        if (location instanceof ItemEntity && eqi instanceof ItemEntity) {
            ((ItemEntity)eqi).func_174869_p();
        }
        return eqi;
    }

    @Override
    public int getBytes(ItemStack is) {
        switch (this.materialType) {
            case ITEM_1K_CELL_COMPONENT: {
                return 1024;
            }
            case ITEM_4K_CELL_COMPONENT: {
                return 4096;
            }
            case ITEM_16K_CELL_COMPONENT: {
                return 16384;
            }
            case ITEM_64K_CELL_COMPONENT: {
                return 65536;
            }
        }
        return 0;
    }

    @Override
    public boolean isStorageComponent(ItemStack is) {
        switch (this.materialType) {
            case ITEM_1K_CELL_COMPONENT: 
            case ITEM_4K_CELL_COMPONENT: 
            case ITEM_16K_CELL_COMPONENT: 
            case ITEM_64K_CELL_COMPONENT: {
                return true;
            }
        }
        return false;
    }
}

