/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.theoneprobe.part;

import appeng.api.parts.IPart;
import appeng.integration.modules.theoneprobe.TheOneProbeText;
import appeng.integration.modules.theoneprobe.part.IPartProbInfoProvider;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import com.google.common.collect.Iterators;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class P2PStateInfoProvider
implements IPartProbInfoProvider {
    private static final int STATE_UNLINKED = 0;
    private static final int STATE_OUTPUT = 1;
    private static final int STATE_INPUT = 2;

    @Override
    public void addProbeInfo(IPart part, ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        if (part instanceof P2PTunnelPart) {
            P2PTunnelPart tunnel = (P2PTunnelPart)part;
            if (!tunnel.isPowered()) {
                return;
            }
            int state = 0;
            int outputCount = 0;
            if (!tunnel.isOutput()) {
                outputCount = P2PStateInfoProvider.getOutputCount(tunnel);
                if (outputCount > 0) {
                    state = 2;
                }
            } else {
                Object input = tunnel.getInput();
                if (input != null) {
                    state = 1;
                }
            }
            switch (state) {
                case 0: {
                    probeInfo.text((ITextComponent)TheOneProbeText.P2P_UNLINKED.getTranslationComponent(new Object[0]));
                    break;
                }
                case 1: {
                    probeInfo.text((ITextComponent)TheOneProbeText.P2P_OUTPUT.getTranslationComponent(new Object[0]));
                    break;
                }
                case 2: {
                    probeInfo.text(P2PStateInfoProvider.getOutputText(outputCount));
                }
            }
            short freq = tunnel.getFrequency();
            StringTextComponent freqTooltip = new StringTextComponent(Platform.p2p().toHexString(freq));
            probeInfo.text((ITextComponent)freqTooltip);
        }
    }

    private static int getOutputCount(P2PTunnelPart tunnel) {
        try {
            return Iterators.size(tunnel.getOutputs().iterator());
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private static ITextComponent getOutputText(int outputs) {
        if (outputs <= 1) {
            return TheOneProbeText.P2P_INPUT_ONE_OUTPUT.getTranslationComponent(new Object[0]);
        }
        return TheOneProbeText.P2P_INPUT_MANY_OUTPUTS.getTranslationComponent(outputs);
    }
}

