/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.GrinderScreen;
import appeng.client.gui.implementations.InscriberScreen;
import appeng.container.me.items.CraftingTermContainer;
import appeng.container.me.items.PatternTermContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.CraftingRecipeTransferHandler;
import appeng.integration.modules.jei.FacadeRegistryPlugin;
import appeng.integration.modules.jei.GhostIngredientHandler;
import appeng.integration.modules.jei.GrinderRecipeCategory;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.JeiRuntimeAdapter;
import appeng.integration.modules.jei.PatternRecipeTransferHandler;
import appeng.items.parts.FacadeItem;
import appeng.recipes.handlers.GrinderRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("appliedenergistics2", "core");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        Optional<Item> maybeFacade = Api.instance().definitions().items().facade().maybeItem();
        maybeFacade.ifPresent(xva$0 -> subtypeRegistry.useNbtForSubtypes(new Item[]{xva$0}));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new GrinderRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CondenserCategory(registry.getJeiHelpers().getGuiHelper()), new InscriberRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingRecipeTransferHandler(CraftingTermContainer.class, registration.getTransferHelper()), VanillaRecipeCategoryUid.CRAFTING);
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new PatternRecipeTransferHandler(PatternTermContainer.class, registration.getTransferHelper()));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IDefinitions definitions = Api.instance().definitions();
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registration.addRecipes(recipeManager.func_215366_a(GrinderRecipe.TYPE).values(), GrinderRecipeCategory.UID);
        registration.addRecipes(recipeManager.func_215366_a(InscriberRecipe.TYPE).values(), InscriberRecipeCategory.UID);
        registration.addRecipes((Collection)ImmutableList.of((Object)((Object)CondenserOutput.MATTER_BALLS), (Object)((Object)CondenserOutput.SINGULARITY)), CondenserCategory.UID);
        this.registerDescriptions(definitions, registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        IDefinitions definitions = Api.instance().definitions();
        ItemStack grindstone = definitions.blocks().grindstone().stack(1);
        registration.addRecipeCatalyst((Object)grindstone, new ResourceLocation[]{GrinderRecipeCategory.UID});
        ItemStack condenser = definitions.blocks().condenser().stack(1);
        registration.addRecipeCatalyst((Object)condenser, new ResourceLocation[]{CondenserCategory.UID});
        ItemStack inscriber = definitions.blocks().inscriber().stack(1);
        registration.addRecipeCatalyst((Object)inscriber, new ResourceLocation[]{InscriberRecipeCategory.UID});
    }

    private void registerDescriptions(IDefinitions definitions, IRecipeRegistration registry) {
        IMaterials materials = definitions.materials();
        ITextComponent[] message = AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN) ? new ITextComponent[]{GuiText.ChargedQuartz.text(), new StringTextComponent(" "), GuiText.ChargedQuartzFind.text()} : new ITextComponent[]{GuiText.ChargedQuartz.text()};
        this.addDescription(registry, materials.certusQuartzCrystalCharged(), message);
        if (AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            this.addDescription(registry, materials.logicProcessorPress(), GuiText.inWorldCraftingPresses.text());
            this.addDescription(registry, materials.calcProcessorPress(), GuiText.inWorldCraftingPresses.text());
            this.addDescription(registry, materials.engProcessorPress(), GuiText.inWorldCraftingPresses.text());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_FLUIX)) {
            this.addDescription(registry, materials.fluixCrystal(), GuiText.inWorldFluix.text());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_SINGULARITY)) {
            this.addDescription(registry, materials.qESingularity(), GuiText.inWorldSingularity.text());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            this.addDescription(registry, materials.purifiedCertusQuartzCrystal(), GuiText.inWorldPurificationCertus.text());
            this.addDescription(registry, materials.purifiedNetherQuartzCrystal(), GuiText.inWorldPurificationNether.text());
            this.addDescription(registry, materials.purifiedFluixCrystal(), GuiText.inWorldPurificationFluix.text());
        }
    }

    private void addDescription(IRecipeRegistration registry, IItemDefinition itemDefinition, ITextComponent ... message) {
        registry.addIngredientInfo((Object)itemDefinition.stack(1), VanillaTypes.ITEM, message);
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        IDefinitions definitions = Api.instance().definitions();
        if (AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_FACADE_CRAFTING)) {
            FacadeItem itemFacade = (FacadeItem)definitions.items().facade().item();
            ItemStack cableAnchor = definitions.parts().cableAnchor().stack(1);
            registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new FacadeRegistryPlugin(itemFacade, cableAnchor));
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AEBaseScreen.class, new IGuiContainerHandler<ContainerScreen<?>>(){

            public List<Rectangle2d> getGuiExtraAreas(ContainerScreen containerScreen) {
                if (containerScreen instanceof AEBaseScreen) {
                    return ((AEBaseScreen)containerScreen).getExclusionZones();
                }
                return Collections.emptyList();
            }

            @Nullable
            public Object getIngredientUnderMouse(ContainerScreen<?> containerScreen, double mouseX, double mouseY) {
                if (containerScreen instanceof AEBaseScreen) {
                    AEBaseScreen baseScreen = (AEBaseScreen)containerScreen;
                    return baseScreen.getIngredientUnderMouse(mouseX, mouseY);
                }
                return null;
            }

            public Collection<IGuiClickableArea> getGuiClickableAreas(ContainerScreen<?> containerScreen, double mouseX, double mouseY) {
                if (containerScreen instanceof GrinderScreen) {
                    return Arrays.asList(IGuiClickableArea.createBasic((int)18, (int)34, (int)55, (int)22, (ResourceLocation[])new ResourceLocation[]{GrinderRecipeCategory.UID}), IGuiClickableArea.createBasic((int)103, (int)40, (int)55, (int)22, (ResourceLocation[])new ResourceLocation[]{GrinderRecipeCategory.UID}));
                }
                if (containerScreen instanceof InscriberScreen) {
                    return Collections.singletonList(IGuiClickableArea.createBasic((int)82, (int)39, (int)26, (int)16, (ResourceLocation[])new ResourceLocation[]{InscriberRecipeCategory.UID}));
                }
                return Collections.emptyList();
            }
        });
        registration.addGhostIngredientHandler(AEBaseScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIFacade.setInstance(new JeiRuntimeAdapter(jeiRuntime));
        this.hideDebugTools(jeiRuntime);
    }

    private void hideDebugTools(IJeiRuntime jeiRuntime) {
        ArrayList<Object> toRemove = new ArrayList<Object>();
        toRemove.add(Api.INSTANCE.definitions().items().dummyFluidItem().maybeStack(1).orElse(null));
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.UNSUPPORTED_DEVELOPER_TOOLS)) {
            toRemove.add(Api.INSTANCE.definitions().blocks().cubeGenerator().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().chunkLoader().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().energyGenerator().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().itemGen().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().blocks().phantomNode().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolDebugCard().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolEraser().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolMeteoritePlacer().maybeStack(1).orElse(null));
            toRemove.add(Api.INSTANCE.definitions().items().toolReplicatorCard().maybeStack(1).orElse(null));
        }
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, toRemove);
    }
}

