/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.container.me.items.CraftingTermContainer;
import appeng.integration.modules.jei.RecipeTransferHandler;
import appeng.util.item.AEItemStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CraftingRecipeTransferHandler
extends RecipeTransferHandler<CraftingTermContainer> {
    CraftingRecipeTransferHandler(Class<CraftingTermContainer> containerClass, IRecipeTransferHandlerHelper helper) {
        super(containerClass, helper);
    }

    @Override
    protected IRecipeTransferError doTransferRecipe(CraftingTermContainer container, IRecipe<?> recipe, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer) {
        ArrayList missingSlots = new ArrayList();
        HashMap<AEItemStack, Integer> reservedGridAmounts = new HashMap<AEItemStack, Integer>();
        for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            List ingredients = ingredient.getAllIngredients();
            if (!ingredient.isInput() || ingredients.isEmpty()) continue;
            boolean found = false;
            for (ItemStack itemStack : ingredients) {
                if (itemStack == null || player.field_71071_by.func_184429_b(itemStack) == -1) continue;
                found = true;
                break;
            }
            if (!found) {
                for (ItemStack itemStack : ingredients) {
                    AEItemStack aeStack;
                    int reservedAmount;
                    if (itemStack == null || !container.hasItemType(itemStack, reservedAmount = reservedGridAmounts.getOrDefault(aeStack = AEItemStack.fromItemStack(itemStack), 0) + 1)) continue;
                    reservedGridAmounts.put(aeStack, reservedAmount);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            missingSlots.add(entry.getKey());
        }
        if (!missingSlots.isEmpty()) {
            TranslationTextComponent message = new TranslationTextComponent("jei.appliedenergistics2.missing_items");
            return new TransferWarning(this.helper.createUserErrorForSlots((ITextComponent)message, missingSlots));
        }
        return null;
    }

    @Override
    protected boolean isCrafting() {
        return true;
    }

    private static class TransferWarning
    implements IRecipeTransferError {
        private final IRecipeTransferError parent;

        public TransferWarning(IRecipeTransferError parent) {
            this.parent = parent;
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(MatrixStack matrixStack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
            this.parent.showError(matrixStack, mouseX, mouseY, recipeLayout, recipeX, recipeY);
        }
    }
}

