/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks.ticking;

import appeng.tile.AEBaseTileEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

class ServerTileRepo {
    private final Map<IWorld, Long2ObjectMap<List<AEBaseTileEntity>>> tiles = new Object2ObjectOpenHashMap();

    ServerTileRepo() {
    }

    void clear() {
        this.tiles.clear();
    }

    synchronized void addTile(AEBaseTileEntity tile) {
        World world = tile.func_145831_w();
        int x = tile.func_174877_v().func_177958_n() >> 4;
        int z = tile.func_174877_v().func_177952_p() >> 4;
        long chunkPos = ChunkPos.func_77272_a((int)x, (int)z);
        Long2ObjectMap<List<AEBaseTileEntity>> worldQueue = this.tiles.get(world);
        ((List)worldQueue.computeIfAbsent(chunkPos, key -> new ArrayList())).add(tile);
    }

    synchronized void addWorld(IWorld world) {
        this.tiles.computeIfAbsent(world, key -> new Long2ObjectOpenHashMap());
    }

    synchronized void removeWorld(IWorld world) {
        this.tiles.remove(world);
    }

    synchronized void removeWorldChunk(IWorld world, long chunkPos) {
        Map queue = (Map)this.tiles.get(world);
        if (queue != null) {
            queue.remove(chunkPos);
        }
    }

    public Long2ObjectMap<List<AEBaseTileEntity>> getTiles(IWorld world) {
        return this.tiles.get(world);
    }
}

