/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.util;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.Api;
import appeng.fluids.items.FluidDummyItem;
import appeng.util.Platform;
import appeng.util.item.AEStack;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class AEFluidStack
extends AEStack<IAEFluidStack>
implements IAEFluidStack,
Comparable<AEFluidStack> {
    private static final String NBT_STACKSIZE = "cnt";
    private static final String NBT_REQUESTABLE = "req";
    private static final String NBT_CRAFTABLE = "craft";
    private static final String NBT_FLUID_ID = "f";
    private static final String NBT_FLUID_TAG = "ft";
    private final Fluid fluid;
    private CompoundNBT tagCompound;

    private AEFluidStack(AEFluidStack fluidStack) {
        this.fluid = fluidStack.fluid;
        this.setStackSize(fluidStack.getStackSize());
        this.setCraftable(fluidStack.isCraftable());
        this.setCountRequestable(fluidStack.getCountRequestable());
        if (fluidStack.hasTagCompound()) {
            this.tagCompound = fluidStack.tagCompound.func_74737_b();
        }
    }

    private AEFluidStack(@Nonnull Fluid fluid, long amount, @Nullable CompoundNBT tag) {
        if (fluid == Fluids.field_204541_a) {
            System.out.println();
        }
        this.fluid = (Fluid)Preconditions.checkNotNull((Object)fluid);
        this.setStackSize(amount);
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.tagCompound = tag;
    }

    public static AEFluidStack fromFluidStack(FluidStack input) {
        if (input.isEmpty()) {
            return null;
        }
        Fluid fluid = input.getFluid();
        if (fluid == null) {
            throw new IllegalArgumentException("Fluid is null.");
        }
        long amount = input.getAmount();
        CompoundNBT tag = null;
        if (input.getTag() != null) {
            tag = input.getTag().func_74737_b();
        }
        return new AEFluidStack(fluid, amount, tag);
    }

    public static IAEFluidStack fromNBT(CompoundNBT data) {
        ResourceLocation fluidId = new ResourceLocation(data.func_74779_i(NBT_FLUID_ID));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        if (fluid == null || fluid == Fluids.field_204541_a) {
            return null;
        }
        CompoundNBT tag = null;
        if (data.func_150297_b(NBT_FLUID_TAG, 10)) {
            tag = data.func_74775_l(NBT_FLUID_TAG);
        }
        long amount = data.func_74763_f(NBT_STACKSIZE);
        AEFluidStack fluidStack = new AEFluidStack(fluid, amount, tag);
        fluidStack.setCountRequestable(data.func_74763_f(NBT_REQUESTABLE));
        fluidStack.setCraftable(data.func_74767_n(NBT_CRAFTABLE));
        return fluidStack;
    }

    @Override
    public void add(IAEFluidStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        data.func_74778_a(NBT_FLUID_ID, this.fluid.getRegistryName().toString());
        if (this.hasTagCompound()) {
            data.func_218657_a(NBT_FLUID_TAG, (INBT)this.tagCompound);
        }
        data.func_74772_a(NBT_STACKSIZE, this.getStackSize());
        data.func_74772_a(NBT_REQUESTABLE, this.getCountRequestable());
        data.func_74757_a(NBT_CRAFTABLE, this.isCraftable());
    }

    @Override
    public boolean fuzzyComparison(IAEFluidStack other, FuzzyMode mode) {
        return this.fluid == other.getFluid();
    }

    @Override
    public IAEFluidStack copy() {
        return new AEFluidStack(this);
    }

    @Override
    public IAEFluidStack empty() {
        IAEFluidStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public int compareTo(AEFluidStack other) {
        if (this.fluid != other.fluid) {
            return this.fluid.getRegistryName().compareTo(other.fluid.getRegistryName());
        }
        if (Platform.itemComparisons().isNbtTagEqual(this.tagCompound, other.tagCompound)) {
            return 0;
        }
        return this.tagCompound.hashCode() - other.tagCompound.hashCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fluid == null ? 0 : this.fluid.hashCode());
        result = 31 * result + (this.tagCompound == null ? 0 : this.tagCompound.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AEFluidStack) {
            AEFluidStack is = (AEFluidStack)other;
            return is.fluid == this.fluid && Platform.itemComparisons().isNbtTagEqual(this.tagCompound, is.tagCompound);
        }
        if (other instanceof FluidStack) {
            FluidStack is = (FluidStack)other;
            return is.getFluid() == this.fluid && Platform.itemComparisons().isNbtTagEqual(this.tagCompound, is.getTag());
        }
        return false;
    }

    public String toString() {
        return this.getStackSize() + "x" + this.getFluidStack().getFluid().getRegistryName() + " " + this.tagCompound;
    }

    @Override
    public boolean hasTagCompound() {
        return this.tagCompound != null;
    }

    @Override
    public FluidStack getFluidStack() {
        int amount = (int)Math.min(Integer.MAX_VALUE, this.getStackSize());
        FluidStack is = new FluidStack(this.fluid, amount, this.tagCompound);
        return is;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public ItemStack asItemStackRepresentation() {
        ItemStack is = Api.instance().definitions().items().dummyFluidItem().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (!is.func_190926_b()) {
            FluidDummyItem item = (FluidDummyItem)is.func_77973_b();
            item.setFluidStack(is, this.getFluidStack());
            return is;
        }
        return ItemStack.field_190927_a;
    }

    public static IAEFluidStack fromPacket(PacketBuffer buffer) {
        boolean isCraftable = buffer.readBoolean();
        Fluid fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        CompoundNBT tag = buffer.func_150793_b();
        long stackSize = buffer.func_179260_f();
        long countRequestable = buffer.func_179260_f();
        AEFluidStack stack = new AEFluidStack(fluid, stackSize, tag);
        stack.setCountRequestable(countRequestable);
        stack.setCraftable(isCraftable);
        return stack;
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        buffer.writeBoolean(this.isCraftable());
        buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (IForgeRegistryEntry)this.fluid);
        buffer.func_150786_a(this.getFluidStack().getTag());
        buffer.func_179254_b(this.getStackSize());
        buffer.func_179254_b(this.getCountRequestable());
    }
}

