/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Upgrades;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.fluids.container.FluidConfigurableContainer;
import appeng.fluids.parts.FluidFormationPlanePart;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;

public class FluidFormationPlaneContainer
extends FluidConfigurableContainer {
    public static final ContainerType<FluidFormationPlaneContainer> TYPE = ContainerTypeBuilder.create(FluidFormationPlaneContainer::new, FluidFormationPlanePart.class).requirePermission(SecurityPermissions.BUILD).build("fluid_formation_plane");
    private final FluidFormationPlanePart plane;

    public FluidFormationPlaneContainer(int id, PlayerInventory ip, FluidFormationPlanePart te) {
        super(TYPE, id, ip, te);
        this.plane = te;
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.plane.getConfig();
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        this.checkToolbox();
        this.standardDetectAndSendChanges();
    }

    @Override
    protected boolean isValidForConfig(int slot, IAEFluidStack fs) {
        int upgrades;
        int y;
        return !this.supportCapacity() || (y = slot / 9) < (upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY)) + 2;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx;
    }

    @Override
    protected boolean supportCapacity() {
        return true;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }
}

