/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.IIngredientSupplier;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import appeng.fluids.client.gui.FluidBlitter;
import appeng.fluids.util.IAEFluidTank;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankWidget
extends Widget
implements ITooltip,
IIngredientSupplier {
    private final IAEFluidTank tank;
    private final int slot;

    public FluidTankWidget(IAEFluidTank tank, int slot) {
        super(0, 0, 0, 0, StringTextComponent.field_240750_d_);
        this.tank = tank;
        this.slot = slot;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        IAEFluidStack fluidStack;
        if (this.field_230694_p_ && (fluidStack = this.tank.getFluidInSlot(this.slot)) != null && fluidStack.getStackSize() > 0L) {
            Blitter blitter = FluidBlitter.create(fluidStack.getFluidStack());
            int filledHeight = (int)((float)this.field_230689_k_ * ((float)fluidStack.getStackSize() / (float)this.tank.getTankCapacity(this.slot)));
            int stepHeight = this.field_230688_j_;
            int iconHeightRemainder = filledHeight % stepHeight;
            for (int i = 0; i < filledHeight / stepHeight; ++i) {
                blitter.dest(this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - iconHeightRemainder - (i + 1) * stepHeight, stepHeight, stepHeight).blit(matrixStack, this.func_230927_p_());
            }
            if (iconHeightRemainder > 0) {
                int srcHeightRemainder = (int)((float)blitter.getSrcHeight() * ((float)iconHeightRemainder / (float)stepHeight));
                blitter.src(blitter.getSrcX(), blitter.getSrcY(), blitter.getSrcWidth(), srcHeightRemainder).dest(this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - iconHeightRemainder, this.field_230688_j_, iconHeightRemainder).blit(matrixStack, this.func_230927_p_());
            }
        }
    }

    @Override
    public List<ITextComponent> getTooltipMessage() {
        IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
        if (fluid != null && fluid.getStackSize() > 0L) {
            return Arrays.asList(fluid.getFluid().getAttributes().getDisplayName(fluid.getFluidStack()), new StringTextComponent(fluid.getStackSize() + "mB"));
        }
        return Collections.emptyList();
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_ - 2;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_ - 2;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.field_230688_j_ + 4;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.field_230689_k_ + 4;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    @Override
    @Nullable
    public FluidStack getFluidIngredient() {
        return this.tank.getFluidInTank(this.slot).copy();
    }
}

