/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.SlotSemantic;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.fluids.client.gui.widgets.FluidSlotWidget;
import appeng.fluids.client.gui.widgets.OptionalFluidSlotWidget;
import appeng.fluids.container.FluidStorageBusContainer;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class FluidStorageBusScreen
extends UpgradeableScreen<FluidStorageBusContainer> {
    private final SettingToggleButton<AccessRestriction> rwMode;
    private final SettingToggleButton<StorageFilter> storageFilter;

    public FluidStorageBusScreen(FluidStorageBusContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        IAEFluidTank config = ((FluidStorageBusContainer)this.field_147002_h).getFluidConfigInventory();
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                int idx = y * 9 + x;
                if (y < 2) {
                    this.addSlot(new FluidSlotWidget(config, idx), SlotSemantic.CONFIG);
                    continue;
                }
                this.addSlot(new OptionalFluidSlotWidget(config, container, idx, y - 2), SlotSemantic.CONFIG);
            }
        }
        this.widgets.addOpenPriorityButton();
        this.addToLeftToolbar(new ActionButton(ActionItems.CLOSE, btn -> this.clear()));
        this.addToLeftToolbar(new ActionButton(ActionItems.WRENCH, btn -> this.partition()));
        this.rwMode = new ServerSettingToggleButton<AccessRestriction>(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton<StorageFilter>(Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.addToLeftToolbar(this.storageFilter);
        this.addToLeftToolbar(this.rwMode);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.storageFilter.set(((FluidStorageBusContainer)this.field_147002_h).getStorageFilter());
        this.rwMode.set(((FluidStorageBusContainer)this.field_147002_h).getReadWriteMode());
    }

    private void partition() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Partition"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Clear"));
    }
}

