/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.sync.packets.MockExplosionPacket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public final class TinyTNTPrimedEntity
extends TNTEntity
implements IEntityAdditionalSpawnData {
    public static EntityType<TinyTNTPrimedEntity> TYPE;
    private LivingEntity placedBy;

    public TinyTNTPrimedEntity(EntityType<? extends TinyTNTPrimedEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70156_m = true;
    }

    public TinyTNTPrimedEntity(World w, double x, double y, double z, LivingEntity igniter) {
        super(TYPE, w);
        this.func_70107_b(x, y, z);
        double d0 = w.field_73012_v.nextDouble() * 6.2831854820251465;
        this.func_213293_j(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.func_184534_a(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.placedBy = igniter;
    }

    @Nullable
    public LivingEntity func_94083_c() {
        return this.placedBy;
    }

    public void func_70071_h_() {
        this.func_233566_aG_();
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, (double)0.04f, 0.0));
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.98f, (double)0.98f, (double)0.98f));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.7f, (double)0.7f, -0.5));
        }
        if (this.func_70090_H() && !this.field_70170_p.func_201670_d()) {
            Api.instance().definitions().blocks().tinyTNT().maybeStack(1).ifPresent(tntStack -> {
                ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), tntStack);
                item.func_213317_d(this.func_213322_ci());
                item.field_70169_q = this.field_70169_q;
                item.field_70167_r = this.field_70167_r;
                item.field_70166_s = this.field_70166_s;
                this.field_70170_p.func_217376_c((Entity)item);
                this.func_70106_y();
            });
        }
        if (this.func_184536_l() <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_70515_d();
            }
        } else {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        this.func_184534_a(this.func_184536_l() - 1);
    }

    protected void func_70515_d() {
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 32.9f);
        if (this.func_70090_H()) {
            return;
        }
        Explosion ex = new Explosion(this.field_70170_p, (Entity)this, null, null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.2f, false, Explosion.Mode.BREAK);
        AxisAlignedBB area = new AxisAlignedBB(this.func_226277_ct_() - 1.5, this.func_226278_cu_() - 1.5, this.func_226281_cx_() - 1.5, this.func_226277_ct_() + 1.5, this.func_226278_cu_() + 1.5, this.func_226281_cx_() + 1.5);
        List list = this.field_70170_p.func_72839_b((Entity)this, area);
        ForgeEventFactory.onExplosionDetonate((World)this.field_70170_p, (Explosion)ex, (List)list, (double)0.4f);
        for (Entity e : list) {
            e.func_70097_a(DamageSource.func_94539_a((Explosion)ex), 6.0f);
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.TINY_TNT_BLOCK_DAMAGE)) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() - 0.25, this.func_226281_cx_());
            int x = (int)(this.func_226277_ct_() - 2.0);
            while ((double)x <= this.func_226277_ct_() + 2.0) {
                int y = (int)(this.func_226278_cu_() - 2.0);
                while ((double)y <= this.func_226278_cu_() + 2.0) {
                    int z = (int)(this.func_226281_cx_() - 2.0);
                    while ((double)z <= this.func_226281_cx_() + 2.0) {
                        BlockPos point = new BlockPos(x, y, z);
                        BlockState state = this.field_70170_p.func_180495_p(point);
                        Block block = state.func_177230_c();
                        if (block != null && !block.isAir(state, (IBlockReader)this.field_70170_p, point)) {
                            float strength = (float)((double)2.3f - (((double)((float)x + 0.5f) - this.func_226277_ct_()) * ((double)((float)x + 0.5f) - this.func_226277_ct_()) + ((double)((float)y + 0.5f) - this.func_226278_cu_()) * ((double)((float)y + 0.5f) - this.func_226278_cu_()) + ((double)((float)z + 0.5f) - this.func_226281_cx_()) * ((double)((float)z + 0.5f) - this.func_226281_cx_())));
                            float resistance = block.getExplosionResistance(state, (IBlockReader)this.field_70170_p, point, ex);
                            if ((double)(strength -= (resistance + 0.3f) * 0.11f) > 0.01 && state.func_185904_a() != Material.field_151579_a) {
                                if (block.func_149659_a(ex)) {
                                    Block.func_220075_c((BlockState)state, (World)this.field_70170_p, (BlockPos)point);
                                }
                                block.onBlockExploded(null, this.field_70170_p, point, ex);
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        AppEng.proxy.sendToAllNearExcept(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 64.0, this.field_70170_p, new MockExplosionPacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeByte(this.func_184536_l());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_184534_a(additionalData.readByte());
    }
}

