/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.tile.AEBaseTileEntity;
import com.google.common.math.IntMath;
import javax.annotation.Nullable;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyGeneratorTileEntity
extends AEBaseTileEntity
implements ITickableTileEntity,
IEnergyStorage {
    private static final int BASE_ENERGY = 8;

    public EnergyGeneratorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world == null || world.field_72995_K) {
            return;
        }
        int tier = 1;
        for (Direction facing : Direction.values()) {
            TileEntity te = world.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (!(te instanceof EnergyGeneratorTileEntity)) continue;
            ++tier;
        }
        int energyToInsert = IntMath.pow((int)8, (int)tier);
        for (Direction facing : Direction.values()) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (te == null) continue;
            LazyOptional cap = te.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
            cap.ifPresent(consumer -> {
                if (consumer.canReceive()) {
                    consumer.receiveEnergy(energyToInsert, false);
                }
            });
        }
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return maxExtract;
    }

    public int getEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

