/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.core.worlddata.IWorldGridStorageData;
import appeng.me.GridStorage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.storage.WorldSavedData;

final class StorageData
extends WorldSavedData
implements IWorldGridStorageData {
    public static final String NAME = "appliedenergistics2_storage";
    private static final String TAG_NEXT_ID = "nextId";
    public static final String TAG_ORDERED_VALUES = "orderedValues";
    public static final String TAG_STORAGE = "storage";
    private final Map<Long, GridStorage> storage = new HashMap<Long, GridStorage>();
    private long nextGridId;
    private final Map<String, Integer> orderedValues = new HashMap<String, Integer>();

    public StorageData() {
        super(NAME);
    }

    @Override
    public GridStorage getGridStorage(long storageID) {
        GridStorage result = this.storage.get(storageID);
        if (result == null) {
            result = new GridStorage(storageID);
            this.storage.put(storageID, result);
        }
        return result;
    }

    @Override
    @Nonnull
    public GridStorage getNewGridStorage() {
        return this.getGridStorage(this.nextGridId++);
    }

    @Override
    public void destroyGridStorage(long id) {
        this.storage.remove(id);
    }

    @Override
    public int getNextOrderedValue(String name, int firstValue) {
        return this.orderedValues.merge(name, firstValue, (oldValue, value) -> oldValue + 1);
    }

    public void func_76184_a(CompoundNBT tag) {
        this.nextGridId = tag.func_74763_f(TAG_NEXT_ID);
        CompoundNBT storageTag = tag.func_74775_l(TAG_STORAGE);
        for (String storageIdStr : storageTag.func_150296_c()) {
            long storageId;
            try {
                storageId = Long.parseLong(storageIdStr);
            }
            catch (NumberFormatException e) {
                AELog.warn("Unable to load grid storage with malformed id: '{}'", storageIdStr);
                continue;
            }
            this.storage.put(storageId, new GridStorage(storageId, storageTag.func_74775_l(storageIdStr)));
        }
        CompoundNBT orderedValuesTag = tag.func_74775_l(TAG_ORDERED_VALUES);
        this.orderedValues.clear();
        for (String key : orderedValuesTag.func_150296_c()) {
            this.orderedValues.put(key, orderedValuesTag.func_74762_e(key));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        tag.func_74772_a(TAG_NEXT_ID, this.nextGridId);
        CompoundNBT storageTag = new CompoundNBT();
        for (Map.Entry<Long, GridStorage> entry : this.storage.entrySet()) {
            GridStorage gridStorage = entry.getValue();
            if (gridStorage.getGrid() == null || gridStorage.getGrid().isEmpty()) continue;
            try {
                entry.getValue().saveState();
            }
            catch (Exception e) {
                AELog.warn("Failed to save state of Grid {}, storing last known value instead.", entry.getKey(), e);
            }
            storageTag.func_218657_a(String.valueOf(entry.getKey()), (INBT)entry.getValue().dataObject());
        }
        tag.func_218657_a(TAG_STORAGE, (INBT)storageTag);
        CompoundNBT orderedValuesTag = new CompoundNBT();
        for (Map.Entry<String, Integer> entry : this.orderedValues.entrySet()) {
            orderedValuesTag.func_74768_a(entry.getKey(), entry.getValue().intValue());
        }
        tag.func_218657_a(TAG_ORDERED_VALUES, (INBT)orderedValuesTag);
        return tag;
    }
}

