/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.me.items.PatternTermContainer;
import appeng.core.Api;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class PatternSlotPacket
extends BasePacket {
    public final IAEItemStack slotItem;
    public final IAEItemStack[] pattern = new IAEItemStack[9];
    public final boolean shift;

    public PatternSlotPacket(PacketBuffer stream) {
        this.shift = stream.readBoolean();
        this.slotItem = this.readItem(stream);
        for (int x = 0; x < 9; ++x) {
            this.pattern[x] = this.readItem(stream);
        }
    }

    private IAEItemStack readItem(PacketBuffer stream) {
        boolean hasItem = stream.readBoolean();
        if (hasItem) {
            return AEItemStack.fromPacket(stream);
        }
        return null;
    }

    public PatternSlotPacket(IItemHandler pat, IAEItemStack slotItem, boolean shift) {
        this.slotItem = slotItem;
        this.shift = shift;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        this.writeItem(slotItem, data);
        for (int x = 0; x < 9; ++x) {
            this.pattern[x] = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(pat.getStackInSlot(x));
            this.writeItem(this.pattern[x], data);
        }
        this.configureWrite(data);
    }

    private void writeItem(IAEItemStack slotItem, PacketBuffer data) {
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        ServerPlayerEntity sender = (ServerPlayerEntity)player;
        if (sender.field_71070_bA instanceof PatternTermContainer) {
            PatternTermContainer patternTerminal = (PatternTermContainer)sender.field_71070_bA;
            patternTerminal.craftOrGetItem(this);
        }
    }
}

