/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.parts.PartPlacement;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;

public class PartPlacementPacket
extends BasePacket {
    private int x;
    private int y;
    private int z;
    private int face;
    private float eyeHeight;
    private Hand hand;

    public PartPlacementPacket(PacketBuffer stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        this.face = stream.readByte();
        this.eyeHeight = stream.readFloat();
        this.hand = Hand.values()[stream.readByte()];
    }

    public PartPlacementPacket(BlockPos pos, Direction face, float eyeHeight, Hand hand) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(pos.func_177958_n());
        data.writeInt(pos.func_177956_o());
        data.writeInt(pos.func_177952_p());
        data.writeByte(face.ordinal());
        data.writeFloat(eyeHeight);
        data.writeByte(hand.ordinal());
        this.configureWrite(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        ServerPlayerEntity sender = (ServerPlayerEntity)player;
        AppEng.proxy.setPartInteractionPlayer((PlayerEntity)sender);
        try {
            PartPlacement.setEyeHeight(this.eyeHeight);
            PartPlacement.place(sender.func_184586_b(this.hand), new BlockPos(this.x, this.y, this.z), Direction.values()[this.face], (PlayerEntity)sender, this.hand, sender.field_70170_p, PartPlacement.PlaceType.INTERACT_FIRST_PASS, 0);
        }
        finally {
            AppEng.proxy.setPartInteractionPlayer(null);
        }
    }
}

