/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.block.networking.CableBusBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.me.networktool.NetworkToolContainer;
import appeng.core.Api;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.NetworkToolItem;
import appeng.items.tools.powered.ColorApplicatorItem;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class ClickPacket
extends BasePacket {
    private final int x;
    private final int y;
    private final int z;
    private Direction side;
    private final float hitX;
    private final float hitY;
    private final float hitZ;
    private Hand hand;
    private final boolean leftClick;

    public ClickPacket(PacketBuffer stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        byte side = stream.readByte();
        this.side = side != -1 ? Direction.values()[side] : null;
        this.hitX = stream.readFloat();
        this.hitY = stream.readFloat();
        this.hitZ = stream.readFloat();
        this.hand = Hand.values()[stream.readByte()];
        this.leftClick = stream.readBoolean();
    }

    public ClickPacket(ItemUseContext context) {
        this(context.func_195995_a(), context.func_196000_l(), context.func_195995_a().func_177958_n(), context.func_195995_a().func_177956_o(), context.func_195995_a().func_177952_p(), context.func_221531_n());
    }

    public ClickPacket(Hand hand) {
        this(BlockPos.field_177992_a, null, 0.0f, 0.0f, 0.0f, hand);
    }

    private ClickPacket(BlockPos pos, Direction side, float hitX, float hitY, float hitZ, Hand hand) {
        this(pos, side, hitX, hitY, hitZ, hand, false);
    }

    public ClickPacket(BlockPos pos, Direction side, float hitX, float hitY, float hitZ, Hand hand, boolean leftClick) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.x = pos.func_177958_n();
        data.writeInt(this.x);
        this.y = pos.func_177956_o();
        data.writeInt(this.y);
        this.z = pos.func_177952_p();
        data.writeInt(this.z);
        if (side == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(side.ordinal());
        }
        this.hitX = hitX;
        data.writeFloat(this.hitX);
        this.hitY = hitY;
        data.writeFloat(this.hitY);
        this.hitZ = hitZ;
        data.writeFloat(this.hitZ);
        data.writeByte(hand.ordinal());
        this.leftClick = leftClick;
        data.writeBoolean(this.leftClick);
        this.configureWrite(data);
    }

    private boolean hasBlockContext() {
        return this.side != null;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        ItemStack is = player.func_184586_b(this.hand);
        IItems items = Api.instance().definitions().items();
        IItemDefinition maybeMemoryCard = items.memoryCard();
        IItemDefinition maybeColorApplicator = items.colorApplicator();
        if (this.leftClick) {
            Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
            if (block instanceof CableBusBlock) {
                ((CableBusBlock)block).onBlockClickPacket(player.field_70170_p, pos, player, this.hand, new Vector3d((double)this.hitX, (double)this.hitY, (double)this.hitZ));
            }
        } else if (!is.func_190926_b()) {
            Object mem;
            if (is.func_77973_b() instanceof NetworkToolItem) {
                NetworkToolItem tnt = (NetworkToolItem)is.func_77973_b();
                if (this.hasBlockContext()) {
                    ItemUseContext useContext = new ItemUseContext(player, this.hand, new BlockRayTraceResult(new Vector3d((double)this.hitX, (double)this.hitY, (double)this.hitZ), this.side, pos, false));
                    tnt.serverSideToolLogic(useContext);
                } else {
                    ContainerOpener.openContainer(NetworkToolContainer.TYPE, player, ContainerLocator.forHand(player, this.hand));
                }
            }
            if (maybeMemoryCard.isSameAs(is)) {
                mem = (IMemoryCard)is.func_77973_b();
                mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
                is.func_77982_d(null);
            } else if (maybeColorApplicator.isSameAs(is)) {
                mem = (ColorApplicatorItem)is.func_77973_b();
                ((ColorApplicatorItem)mem).cycleColors(is, ((ColorApplicatorItem)mem).getColor(is), 1);
            }
        }
    }
}

