/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridCacheFactory;
import appeng.api.networking.IGridCacheRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class GridCacheRegistry
implements IGridCacheRegistry {
    private final List<GridCacheRegistration<?>> registry = new ArrayList();

    @Override
    public synchronized <T extends IGridCache> void registerGridCache(@Nonnull Class<T> iface, @Nonnull IGridCacheFactory<T> factory) {
        if (this.registry.stream().anyMatch(r -> ((GridCacheRegistration)r).cacheClass.equals(iface))) {
            throw new IllegalArgumentException("Implementation for grid cache " + iface + " is already registered!");
        }
        this.registry.add(new GridCacheRegistration<T>(iface, factory));
    }

    @Override
    public Map<Class<? extends IGridCache>, IGridCache> createCacheInstance(IGrid g) {
        HashMap<Class<? extends IGridCache>, IGridCache> map = new HashMap<Class<? extends IGridCache>, IGridCache>(this.registry.size());
        for (GridCacheRegistration<?> registration : this.registry) {
            map.put(((GridCacheRegistration)registration).cacheClass, (IGridCache)((GridCacheRegistration)registration).factory.createCache(g));
        }
        return map;
    }

    private static class GridCacheRegistration<T extends IGridCache> {
        private final Class<T> cacheClass;
        private final IGridCacheFactory<T> factory;

        public GridCacheRegistration(Class<T> cacheClass, IGridCacheFactory<T> factory) {
            this.cacheClass = cacheClass;
            this.factory = factory;
        }
    }
}

