/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.client.ICellModelRegistry;
import appeng.api.client.IClientHelper;
import appeng.api.config.IncludeExclude;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.core.ApiDefinitions;
import appeng.core.api.client.ApiCellModelRegistry;
import appeng.core.localization.GuiText;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ApiClientHelper
implements IClientHelper {
    private final ICellModelRegistry cells;

    public ApiClientHelper(ApiDefinitions definitions) {
        this.cells = new ApiCellModelRegistry(definitions);
    }

    @Override
    public <T extends IAEStack<T>> void addCellInformation(ICellInventoryHandler<T> handler, List<ITextComponent> lines) {
        if (handler == null) {
            return;
        }
        ICellInventory<T> cellInventory = handler.getCellInv();
        if (cellInventory != null) {
            lines.add((ITextComponent)new StringTextComponent(cellInventory.getUsedBytes() + " ").func_230529_a_(GuiText.Of.text()).func_240702_b_(" " + cellInventory.getTotalBytes() + " ").func_230529_a_(GuiText.BytesUsed.text()));
            lines.add((ITextComponent)new StringTextComponent(cellInventory.getStoredItemTypes() + " ").func_230529_a_(GuiText.Of.text()).func_240702_b_(" " + cellInventory.getTotalItemTypes() + " ").func_230529_a_(GuiText.Types.text()));
        }
        if (handler.isPreformatted()) {
            String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
            if (handler.isFuzzy()) {
                lines.add((ITextComponent)GuiText.Partitioned.withSuffix(" - " + list + " ").func_230529_a_(GuiText.Fuzzy.text()));
            } else {
                lines.add((ITextComponent)GuiText.Partitioned.withSuffix(" - " + list + " ").func_230529_a_(GuiText.Precise.text()));
            }
        }
    }

    @Override
    public ICellModelRegistry cells() {
        return this.cells;
    }
}

