/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.storage.ITerminalHost;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.crafting.CraftingCPUContainer;
import appeng.container.me.crafting.CraftingCPUCycler;
import appeng.container.me.crafting.CraftingCPUCyclingContainer;
import appeng.container.me.crafting.CraftingCPURecord;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.text.ITextComponent;

public class CraftingStatusContainer
extends CraftingCPUContainer
implements CraftingCPUCyclingContainer {
    public static final ContainerType<CraftingStatusContainer> TYPE = ContainerTypeBuilder.create(CraftingStatusContainer::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftingstatus");
    private final CraftingCPUCycler cpuCycler = new CraftingCPUCycler(this::cpuMatches, this::onCPUSelectionChanged);
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public ITextComponent cpuName;

    public CraftingStatusContainer(int id, PlayerInventory ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
    }

    @Override
    public void func_75142_b() {
        IGrid network = this.getGrid();
        if (this.isServer() && network != null) {
            this.cpuCycler.detectAndSendChanges(network);
        }
        super.func_75142_b();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.isBusy();
    }

    private void onCPUSelectionChanged(CraftingCPURecord cpuRecord, boolean cpusAvailable) {
        boolean bl = this.noCPU = !cpusAvailable;
        if (cpuRecord == null) {
            this.cpuName = null;
            this.setCPU(null);
        } else {
            this.cpuName = cpuRecord.getName();
            this.setCPU(cpuRecord.getCpu());
        }
    }

    @Override
    public void cycleSelectedCPU(boolean forward) {
        this.cpuCycler.cycleCpu(forward);
    }
}

