/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpener;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.crafting.CraftAmountContainer;
import appeng.container.me.crafting.CraftingCPUCycler;
import appeng.container.me.crafting.CraftingCPUCyclingContainer;
import appeng.container.me.crafting.CraftingCPURecord;
import appeng.container.me.crafting.CraftingPlanSummary;
import appeng.container.me.items.CraftingTermContainer;
import appeng.container.me.items.ItemTerminalContainer;
import appeng.container.me.items.PatternTermContainer;
import appeng.container.me.items.WirelessTermContainer;
import appeng.core.AELog;
import appeng.core.sync.packets.CraftConfirmPlanPacket;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.me.helpers.PlayerSource;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.parts.reporting.TerminalPart;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class CraftConfirmContainer
extends AEBaseContainer
implements CraftingCPUCyclingContainer {
    private static final String ACTION_BACK = "back";
    public static final ContainerType<CraftConfirmContainer> TYPE = ContainerTypeBuilder.create(CraftConfirmContainer::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftconfirm");
    private final CraftingCPUCycler cpuCycler = new CraftingCPUCycler(this::cpuMatches, this::onCPUSelectionChanged);
    private ICraftingCPU selectedCpu;
    private IAEItemStack itemToCreate;
    private Future<ICraftingJob> job;
    private ICraftingJob result;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=7)
    public ITextComponent cpuName;
    private CraftingPlanSummary plan;

    public CraftConfirmContainer(int id, PlayerInventory ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
        this.cpuCycler.setAllowNoSelection(true);
        this.registerClientAction(ACTION_BACK, this::goBack);
    }

    @Override
    public void cycleSelectedCPU(boolean next) {
        this.cpuCycler.cycleCpu(next);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.isClient()) {
            return;
        }
        IGrid grid = this.getGrid();
        if (grid == null) {
            this.setValidContainer(false);
            return;
        }
        this.cpuCycler.detectAndSendChanges(grid);
        if (this.job != null && this.job.isDone()) {
            try {
                this.result = this.job.get();
                if (!this.result.isSimulation() && this.isAutoStart()) {
                    this.startJob();
                    return;
                }
                this.plan = CraftingPlanSummary.fromJob(this.getGrid(), this.getActionSrc(), this.result);
                this.sendPacketToClient(new CraftConfirmPlanPacket(this.plan));
            }
            catch (Throwable e) {
                this.getPlayerInventory().field_70458_d.func_145747_a((ITextComponent)new StringTextComponent("Error: " + e.toString()), Util.field_240973_b_);
                AELog.debug(e);
                this.setValidContainer(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    private IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        IGridNode a = h.getActionableNode();
        return a != null ? a.getGrid() : null;
    }

    private boolean cpuMatches(ICraftingCPU c) {
        if (this.plan == null) {
            return true;
        }
        return c.getAvailableStorage() >= this.plan.getUsedBytes() && !c.isBusy();
    }

    public void startJob() {
        Object originalGui = null;
        IActionHost ah = this.getActionHost();
        if (ah instanceof WirelessTerminalGuiObject) {
            originalGui = WirelessTermContainer.TYPE;
        }
        if (ah instanceof TerminalPart) {
            originalGui = ItemTerminalContainer.TYPE;
        }
        if (ah instanceof CraftingTerminalPart) {
            originalGui = CraftingTermContainer.TYPE;
        }
        if (ah instanceof PatternTerminalPart) {
            originalGui = PatternTermContainer.TYPE;
        }
        if (this.result != null && !this.result.isSimulation()) {
            ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
            ICraftingLink g = cc.submitJob(this.result, null, this.selectedCpu, true, this.getActionSrc());
            this.setAutoStart(false);
            if (g != null && originalGui != null && this.getLocator() != null) {
                ContainerOpener.openContainer(originalGui, this.getPlayerInventory().field_70458_d, this.getLocator());
            }
        }
    }

    private IActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInventory().field_70458_d, (IActionHost)this.getTarget());
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.job != null) {
            this.job.cancel(true);
            this.setJob(null);
        }
    }

    public void func_75134_a(PlayerEntity par1PlayerEntity) {
        super.func_75134_a(par1PlayerEntity);
        if (this.job != null) {
            this.job.cancel(true);
            this.setJob(null);
        }
    }

    private void onCPUSelectionChanged(CraftingCPURecord cpuRecord, boolean cpusAvailable) {
        boolean bl = this.noCPU = !cpusAvailable;
        if (cpuRecord == null) {
            this.cpuBytesAvail = 0L;
            this.cpuCoProcessors = 0;
            this.cpuName = null;
            this.selectedCpu = null;
        } else {
            this.cpuBytesAvail = cpuRecord.getSize();
            this.cpuCoProcessors = cpuRecord.getProcessors();
            this.cpuName = cpuRecord.getName();
            this.selectedCpu = cpuRecord.getCpu();
        }
    }

    public World getWorld() {
        return this.getPlayerInventory().field_70458_d.field_70170_p;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public long getCpuAvailableBytes() {
        return this.cpuBytesAvail;
    }

    public int getCpuCoProcessors() {
        return this.cpuCoProcessors;
    }

    public ITextComponent getName() {
        return this.cpuName;
    }

    public boolean hasNoCPU() {
        return this.noCPU;
    }

    public void setItemToCreate(IAEItemStack itemToCreate) {
        this.itemToCreate = itemToCreate;
    }

    public void setJob(Future<ICraftingJob> job) {
        this.job = job;
    }

    @Nullable
    public CraftingPlanSummary getPlan() {
        return this.plan;
    }

    public void setPlan(CraftingPlanSummary plan) {
        this.plan = plan;
    }

    public void goBack() {
        PlayerEntity player = this.getPlayerInventory().field_70458_d;
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (this.itemToCreate != null) {
                CraftAmountContainer.open(serverPlayer, this.getLocator(), this.itemToCreate, (int)this.itemToCreate.getStackSize());
            }
        } else {
            this.sendClientAction(ACTION_BACK);
        }
    }
}

