/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.MolecularAssemblerPatternSlot;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.items.misc.EncodedPatternItem;
import appeng.tile.crafting.MolecularAssemblerTileEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class MolecularAssemblerContainer
extends UpgradeableContainer
implements IProgressProvider {
    public static final ContainerType<MolecularAssemblerContainer> TYPE = ContainerTypeBuilder.create(MolecularAssemblerContainer::new, MolecularAssemblerTileEntity.class).build("molecular_assembler");
    private static final int MAX_CRAFT_PROGRESS = 100;
    private final MolecularAssemblerTileEntity tma;
    @GuiSync(value=4)
    public int craftProgress = 0;
    private Slot encodedPatternSlot;

    public MolecularAssemblerContainer(int id, PlayerInventory ip, MolecularAssemblerTileEntity te) {
        super(TYPE, id, ip, te);
        this.tma = te;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack i) {
        IItemHandler mac = this.getUpgradeable().getInventoryByName("molecular_assembler");
        ItemStack is = mac.getStackInSlot(10);
        if (is.func_190926_b()) {
            return false;
        }
        if (is.func_77973_b() instanceof EncodedPatternItem) {
            World w = this.getTileEntity().func_145831_w();
            ICraftingPatternDetails ph = Api.instance().crafting().decodePattern(is, w);
            if (ph != null && ph.isCraftable()) {
                return ph.isValidItemForSlot(slotIndex, i, w);
            }
        }
        return false;
    }

    @Override
    protected void setupConfig() {
        IItemHandler mac = this.getUpgradeable().getInventoryByName("molecular_assembler");
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new MolecularAssemblerPatternSlot(this, mac, i), SlotSemantic.MACHINE_CRAFTING_GRID);
        }
        this.encodedPatternSlot = this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_CRAFTING_PATTERN, mac, 10), SlotSemantic.ENCODED_PATTERN);
        this.addSlot(new OutputSlot(mac, 9, null), SlotSemantic.MACHINE_OUTPUT);
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        this.craftProgress = this.tma.getCraftingProgress();
        this.standardDetectAndSendChanges();
    }

    @Override
    public int getCurrentProgress() {
        return this.craftProgress;
    }

    @Override
    public int getMaxProgress() {
        return 100;
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot) {
            for (Slot otherSlot : this.field_75151_b) {
                if (otherSlot == s || !(otherSlot instanceof AppEngSlot)) continue;
                ((AppEngSlot)otherSlot).resetCachedValidation();
            }
        }
    }
}

