/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.definitions.IItemDefinition;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.tile.misc.InscriberRecipes;
import appeng.tile.misc.InscriberTileEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InscriberContainer
extends UpgradeableContainer
implements IProgressProvider {
    public static final ContainerType<InscriberContainer> TYPE = ContainerTypeBuilder.create(InscriberContainer::new, InscriberTileEntity.class).build("inscriber");
    private final InscriberTileEntity ti;
    private final Slot top;
    private final Slot middle;
    private final Slot bottom;
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;

    public InscriberContainer(int id, PlayerInventory ip, InscriberTileEntity te) {
        super(TYPE, id, ip, te);
        this.ti = te;
        IItemHandler inv = te.getInternalInventory();
        RestrictedInputSlot top = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_PLATE, inv, 0);
        top.setStackLimit(1);
        this.top = this.addSlot(top, SlotSemantic.INSCRIBER_PLATE_TOP);
        RestrictedInputSlot bottom = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_PLATE, inv, 1);
        bottom.setStackLimit(1);
        this.bottom = this.addSlot(bottom, SlotSemantic.INSCRIBER_PLATE_BOTTOM);
        RestrictedInputSlot middle = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_INPUT, inv, 2);
        middle.setStackLimit(1);
        this.middle = this.addSlot(middle, SlotSemantic.MACHINE_INPUT);
        this.addSlot(new OutputSlot(inv, 3, null), SlotSemantic.MACHINE_OUTPUT);
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 3;
    }

    @Override
    public void func_75142_b() {
        this.standardDetectAndSendChanges();
        if (this.isServer()) {
            this.maxProcessingTime = this.ti.getMaxProcessingTime();
            this.processingTime = this.ti.getProcessingTime();
        }
    }

    @Override
    public boolean isValidForSlot(Slot s, ItemStack is) {
        ItemStack top = this.ti.getInternalInventory().getStackInSlot(0);
        ItemStack bot = this.ti.getInternalInventory().getStackInSlot(1);
        if (s == this.middle) {
            IItemDefinition press = Api.instance().definitions().materials().namePress();
            if (press.isSameAs(top) || press.isSameAs(bot)) {
                return !press.isSameAs(is);
            }
            return InscriberRecipes.findRecipe(this.ti.func_145831_w(), is, top, bot, false) != null;
        }
        if (s == this.top && !bot.func_190926_b() || s == this.bottom && !top.func_190926_b()) {
            ItemStack otherSlot = s == this.top ? this.bottom.func_75211_c() : this.top.func_75211_c();
            IItemDefinition namePress = Api.instance().definitions().materials().namePress();
            if (namePress.isSameAs(otherSlot)) {
                return namePress.isSameAs(is);
            }
            return InscriberRecipes.isValidOptionalIngredientCombination(this.ti.func_145831_w(), is, otherSlot);
        }
        return true;
    }

    @Override
    public int getCurrentProgress() {
        return this.processingTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProcessingTime;
    }
}

