/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.storage.IOPortTileEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.items.IItemHandler;

public class IOPortContainer
extends UpgradeableContainer {
    public static final ContainerType<IOPortContainer> TYPE = ContainerTypeBuilder.create(IOPortContainer::new, IOPortTileEntity.class).requirePermission(SecurityPermissions.BUILD).build("ioport");
    @GuiSync(value=2)
    public FullnessMode fMode = FullnessMode.EMPTY;
    @GuiSync(value=3)
    public OperationMode opMode = OperationMode.EMPTY;

    public IOPortContainer(int id, PlayerInventory ip, IOPortTileEntity te) {
        super(TYPE, id, ip, te);
    }

    @Override
    protected void setupConfig() {
        int i;
        IItemHandler cells = this.getUpgradeable().getInventoryByName("cells");
        for (i = 0; i < 6; ++i) {
            this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.STORAGE_CELLS, cells, i), SlotSemantic.MACHINE_INPUT);
        }
        for (i = 0; i < 6; ++i) {
            this.addSlot(new OutputSlot(cells, 6 + i, RestrictedInputSlot.PlacableItemType.STORAGE_CELLS.icon), SlotSemantic.MACHINE_OUTPUT);
        }
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 3;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.setOperationMode((OperationMode)this.getUpgradeable().getConfigManager().getSetting(Settings.OPERATION_MODE));
            this.setFullMode((FullnessMode)this.getUpgradeable().getConfigManager().getSetting(Settings.FULLNESS_MODE));
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED));
        }
        this.standardDetectAndSendChanges();
    }

    public FullnessMode getFullMode() {
        return this.fMode;
    }

    private void setFullMode(FullnessMode fMode) {
        this.fMode = fMode;
    }

    public OperationMode getOperationMode() {
        return this.opMode;
    }

    private void setOperationMode(OperationMode opMode) {
        this.opMode = opMode;
    }
}

