/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.spatial;

import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.spatial.SpatialPylonBakedModel;
import appeng.client.render.spatial.SpatialPylonTextureType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

public class SpatialPylonModel
implements BasicUnbakedModel<SpatialPylonModel> {
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        EnumMap<SpatialPylonTextureType, TextureAtlasSprite> textures = new EnumMap<SpatialPylonTextureType, TextureAtlasSprite>(SpatialPylonTextureType.class);
        for (SpatialPylonTextureType type : SpatialPylonTextureType.values()) {
            textures.put(type, spriteGetter.apply(SpatialPylonModel.getTexturePath(type)));
        }
        return new SpatialPylonBakedModel(textures);
    }

    @Override
    public Stream<RenderMaterial> getAdditionalTextures() {
        return Arrays.stream(SpatialPylonTextureType.values()).map(SpatialPylonModel::getTexturePath);
    }

    private static RenderMaterial getTexturePath(SpatialPylonTextureType type) {
        return new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/spatial_pylon/" + type.name().toLowerCase(Locale.ROOT)));
    }
}

