/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.overlay;

import appeng.api.util.DimensionalCoord;
import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayRenderer;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverlayManager {
    private static final OverlayManager INSTANCE = new OverlayManager();
    private final Map<DimensionalCoord, OverlayRenderer> overlayHandlers = new HashMap<DimensionalCoord, OverlayRenderer>();

    public static OverlayManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = minecraft.func_228019_au_().func_228487_b_();
        MatrixStack matrixStack = event.getMatrixStack();
        matrixStack.func_227860_a_();
        Vector3d projectedView = minecraft.field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        for (OverlayRenderer handler : this.overlayHandlers.entrySet().stream().filter(e -> ((DimensionalCoord)e.getKey()).getWorld() == minecraft.field_71441_e).map(Map.Entry::getValue).collect(Collectors.toList())) {
            handler.render(matrixStack, (IRenderTypeBuffer)buffer);
        }
        matrixStack.func_227865_b_();
    }

    public OverlayRenderer showArea(IOverlayDataSource source) {
        Preconditions.checkNotNull((Object)source);
        OverlayRenderer handler = new OverlayRenderer(source);
        this.overlayHandlers.put(source.getOverlaySourceLocation(), handler);
        return handler;
    }

    public boolean isShowing(IOverlayDataSource source) {
        return this.overlayHandlers.containsKey(source.getOverlaySourceLocation());
    }

    public void removeHandlers(IOverlayDataSource source) {
        this.overlayHandlers.remove(source.getOverlaySourceLocation());
    }
}

