/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.client.ICellModelRegistry;
import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.model.DriveBakedModel;
import appeng.core.Api;
import appeng.core.api.client.ApiCellModelRegistry;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

public class DriveModel
implements BasicUnbakedModel<DriveModel> {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2:block/drive/drive_base");
    private static final ResourceLocation MODEL_CELL_EMPTY = new ResourceLocation("appliedenergistics2:block/drive/drive_cell_empty");

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ICellModelRegistry cellRegistry = Api.instance().client().cells();
        IdentityHashMap<Item, IBakedModel> cellModels = new IdentityHashMap<Item, IBakedModel>();
        for (Map.Entry<Item, ResourceLocation> entry : cellRegistry.models().entrySet()) {
            IBakedModel cellModel = bakery.getBakedModel(entry.getValue(), modelTransform, spriteGetter);
            cellModels.put(entry.getKey(), cellModel);
        }
        IBakedModel baseModel = bakery.getBakedModel(MODEL_BASE, modelTransform, spriteGetter);
        IBakedModel defaultCell = bakery.getBakedModel(cellRegistry.getDefaultModel(), modelTransform, spriteGetter);
        cellModels.put(Items.field_190931_a, bakery.getBakedModel(MODEL_CELL_EMPTY, modelTransform, spriteGetter));
        return new DriveBakedModel(baseModel, cellModels, defaultCell);
    }

    @Override
    public Collection<ResourceLocation> getModelDependencies() {
        ICellModelRegistry cells = Api.instance().client().cells();
        return ImmutableSet.builder().add((Object)cells.getDefaultModel()).addAll(ApiCellModelRegistry.getModels()).addAll(cells.models().values()).build();
    }
}

