/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;

public class TesrRenderHelper {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;

    public static void rotateToFace(MatrixStack mStack, Direction face, byte spin) {
        switch (face) {
            case UP: {
                mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
                mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-spin) * 90.0f));
                break;
            }
            case DOWN: {
                mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)spin * -90.0f));
                break;
            }
            case EAST: {
                mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case WEST: {
                mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                break;
            }
            case NORTH: {
                mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
        }
    }

    public static void renderItem2d(MatrixStack matrixStack, IRenderTypeBuffer buffers, ItemStack itemStack, float scale, int combinedLightIn, int combinedOverlayIn) {
        if (!itemStack.func_190926_b()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, (double)0.01f);
            matrixStack.func_227862_a_(scale, scale, 2.0E-4f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.GUI, combinedLightIn, OverlayTexture.field_229196_a_, matrixStack, buffers);
            matrixStack.func_227865_b_();
        }
    }

    public static void renderItem2dWithAmount(MatrixStack matrixStack, IRenderTypeBuffer buffers, IAEItemStack itemStack, float itemScale, float spacing, int combinedLightIn, int combinedOverlayIn) {
        ItemStack renderStack = itemStack.asItemStackRepresentation();
        TesrRenderHelper.renderItem2d(matrixStack, buffers, renderStack, itemScale, combinedLightIn, combinedOverlayIn);
        long stackSize = itemStack.getStackSize();
        String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedStackSize);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)spacing, (double)0.02f);
        matrixStack.func_227862_a_(0.016129032f, -0.016129032f, 0.016129032f);
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.0f);
        matrixStack.func_227861_a_((double)(-0.5f * (float)width), 0.0, 0.5);
        fr.func_228079_a_(renderedStackSize, 0.0f, 0.0f, 0, false, matrixStack.func_227866_c_().func_227870_a_(), buffers, false, 0, 0xF000F0);
        matrixStack.func_227865_b_();
    }
}

