/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.config.ActionItems;
import appeng.client.gui.Icon;
import appeng.client.gui.widgets.IconButton;
import appeng.core.localization.ButtonToolTips;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ActionButton
extends IconButton {
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private final Icon icon;

    public ActionButton(ActionItems action, Consumer<ActionItems> onPress) {
        super(btn -> onPress.accept(action));
        ButtonToolTips displayValue;
        ButtonToolTips displayName;
        switch (action) {
            case WRENCH: {
                this.icon = Icon.WRENCH;
                displayName = ButtonToolTips.PartitionStorage;
                displayValue = ButtonToolTips.PartitionStorageHint;
                break;
            }
            case CLOSE: {
                this.icon = Icon.CLEAR;
                displayName = ButtonToolTips.Clear;
                displayValue = ButtonToolTips.ClearSettings;
                break;
            }
            case STASH: {
                this.icon = Icon.CLEAR;
                displayName = ButtonToolTips.Stash;
                displayValue = ButtonToolTips.StashDesc;
                break;
            }
            case ENCODE: {
                this.icon = Icon.WHITE_ARROW_DOWN;
                displayName = ButtonToolTips.Encode;
                displayValue = ButtonToolTips.EncodeDescription;
                break;
            }
            case ENABLE_SUBSTITUTION: {
                this.icon = Icon.SUBSTITUTION_ENABLED;
                displayName = ButtonToolTips.Substitutions;
                displayValue = ButtonToolTips.SubstitutionsDescEnabled;
                break;
            }
            case DISABLE_SUBSTITUTION: {
                this.icon = Icon.SUBSTITUTION_DISABLED;
                displayName = ButtonToolTips.Substitutions;
                displayValue = ButtonToolTips.SubstitutionsDescDisabled;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ActionItem: " + (Object)((Object)action));
            }
        }
        this.func_238482_a_(this.buildMessage(displayName, displayValue));
    }

    @Override
    protected Icon getIcon() {
        return this.icon;
    }

    private ITextComponent buildMessage(ButtonToolTips displayName, ButtonToolTips displayValue) {
        String name = displayName.text().getString();
        String value = displayValue.text().getString();
        StringBuilder sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"));
        int i = sb.lastIndexOf("\n");
        if (i <= 0) {
            i = 0;
        }
        while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        return new StringTextComponent(name + '\n' + sb);
    }
}

