/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.style;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.JSONUtils;

public enum Rectangle2dDeserializer implements JsonDeserializer<Rectangle2d>
{
    INSTANCE;


    public Rectangle2d deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            JsonArray arr = json.getAsJsonArray();
            if (arr.size() != 4) {
                throw new JsonParseException("Rectangles expressed as arrays must have 4 elements.");
            }
            int x = arr.get(0).getAsInt();
            int y = arr.get(1).getAsInt();
            int width = arr.get(2).getAsInt();
            int height = arr.get(3).getAsInt();
            return new Rectangle2d(x, y, width, height);
        }
        JsonObject obj = json.getAsJsonObject();
        int x = JSONUtils.func_151208_a((JsonObject)obj, (String)"x", (int)0);
        int y = JSONUtils.func_151208_a((JsonObject)obj, (String)"y", (int)0);
        int width = JSONUtils.func_151203_m((JsonObject)obj, (String)"width");
        int height = JSONUtils.func_151203_m((JsonObject)obj, (String)"height");
        return new Rectangle2d(x, y, width, height);
    }
}

