/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.style;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class Blitter {
    public static final int DEFAULT_TEXTURE_WIDTH = 256;
    public static final int DEFAULT_TEXTURE_HEIGHT = 256;
    private final ResourceLocation texture;
    private final int referenceWidth;
    private final int referenceHeight;
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int a = 255;
    private Rectangle2d srcRect;
    private Rectangle2d destRect = new Rectangle2d(0, 0, 0, 0);
    private boolean blending = true;

    Blitter(ResourceLocation texture, int referenceWidth, int referenceHeight) {
        this.texture = texture;
        this.referenceWidth = referenceWidth;
        this.referenceHeight = referenceHeight;
    }

    public static Blitter texture(ResourceLocation file) {
        return Blitter.texture(file, 256, 256);
    }

    public static Blitter texture(String file) {
        return Blitter.texture(file, 256, 256);
    }

    public static Blitter texture(ResourceLocation file, int referenceWidth, int referenceHeight) {
        return new Blitter(file, referenceWidth, referenceHeight);
    }

    public static Blitter texture(String file, int referenceWidth, int referenceHeight) {
        return new Blitter(new ResourceLocation("appliedenergistics2", "textures/" + file), referenceWidth, referenceHeight);
    }

    public static Blitter sprite(TextureAtlasSprite sprite) {
        int refSize = Integer.MAX_VALUE;
        AtlasTexture atlas = sprite.func_229241_m_();
        return new Blitter(atlas.func_229223_g_(), Integer.MAX_VALUE, Integer.MAX_VALUE).src((int)(sprite.func_94209_e() * 2.1474836E9f), (int)(sprite.func_94206_g() * 2.1474836E9f), (int)((sprite.func_94212_f() - sprite.func_94209_e()) * 2.1474836E9f), (int)((sprite.func_94210_h() - sprite.func_94206_g()) * 2.1474836E9f));
    }

    public Blitter copy() {
        Blitter result = new Blitter(this.texture, this.referenceWidth, this.referenceHeight);
        result.srcRect = this.srcRect;
        result.destRect = this.destRect;
        result.r = this.r;
        result.g = this.g;
        result.b = this.b;
        result.a = this.a;
        return result;
    }

    public int getSrcX() {
        return this.srcRect == null ? 0 : this.srcRect.func_199318_a();
    }

    public int getSrcY() {
        return this.srcRect == null ? 0 : this.srcRect.func_199319_b();
    }

    public int getSrcWidth() {
        return this.srcRect == null ? this.destRect.func_199316_c() : this.srcRect.func_199316_c();
    }

    public int getSrcHeight() {
        return this.srcRect == null ? this.destRect.func_199317_d() : this.srcRect.func_199317_d();
    }

    public Blitter src(int x, int y, int w, int h) {
        this.srcRect = new Rectangle2d(x, y, w, h);
        return this;
    }

    public Blitter src(Rectangle2d rect) {
        return this.src(rect.func_199318_a(), rect.func_199319_b(), rect.func_199316_c(), rect.func_199317_d());
    }

    public Blitter dest(int x, int y, int w, int h) {
        this.destRect = new Rectangle2d(x, y, w, h);
        return this;
    }

    public Blitter dest(int x, int y) {
        return this.dest(x, y, 0, 0);
    }

    public Blitter dest(Rectangle2d rect) {
        return this.dest(rect.func_199318_a(), rect.func_199319_b(), rect.func_199316_c(), rect.func_199317_d());
    }

    public Rectangle2d getDestRect() {
        int x = this.destRect.func_199318_a();
        int y = this.destRect.func_199319_b();
        int w = 0;
        int h = 0;
        if (this.destRect.func_199316_c() != 0 && this.destRect.func_199317_d() != 0) {
            w = this.destRect.func_199316_c();
            h = this.destRect.func_199317_d();
        } else if (this.srcRect != null) {
            w = this.srcRect.func_199316_c();
            h = this.srcRect.func_199317_d();
        }
        return new Rectangle2d(x, y, w, h);
    }

    public Blitter color(float r, float g, float b) {
        this.r = (int)(MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f) * 255.0f);
        this.g = (int)(MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f) * 255.0f);
        this.b = (int)(MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public Blitter opacity(float a) {
        this.a = (int)(MathHelper.func_76131_a((float)a, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public Blitter color(float r, float g, float b, float a) {
        return this.color(r, g, b).opacity(a);
    }

    public Blitter blending(boolean enable) {
        this.blending = enable;
        return this;
    }

    public Blitter colorRgb(int packedRgb) {
        float r = (float)(packedRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedRgb & 0xFF) / 255.0f;
        return this.color(r, g, b);
    }

    public void blit(MatrixStack matrices, int zIndex) {
        float maxU;
        float maxV;
        float minU;
        float minV;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.texture);
        if (this.srcRect == null) {
            minV = 0.0f;
            minU = 0.0f;
            maxV = 1.0f;
            maxU = 1.0f;
        } else {
            minU = (float)this.srcRect.func_199318_a() / (float)this.referenceWidth;
            minV = (float)this.srcRect.func_199319_b() / (float)this.referenceHeight;
            maxU = (float)(this.srcRect.func_199318_a() + this.srcRect.func_199316_c()) / (float)this.referenceWidth;
            maxV = (float)(this.srcRect.func_199319_b() + this.srcRect.func_199317_d()) / (float)this.referenceHeight;
        }
        float x1 = this.destRect.func_199318_a();
        float y1 = this.destRect.func_199319_b();
        float x2 = x1;
        float y2 = y1;
        if (this.destRect.func_199316_c() != 0 && this.destRect.func_199317_d() != 0) {
            x2 += (float)this.destRect.func_199316_c();
            y2 += (float)this.destRect.func_199317_d();
        } else if (this.srcRect != null) {
            x2 += (float)this.srcRect.func_199316_c();
            y2 += (float)this.srcRect.func_199317_d();
        }
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, x1, y2, (float)zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y2, (float)zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y1, (float)zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x1, y1, (float)zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        if (this.blending) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
        } else {
            RenderSystem.disableBlend();
        }
        RenderSystem.enableTexture();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

